/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker.implementation.generic.container;

import com.gamedash.daemon.common.time.Time;
import com.gamedash.daemon.docker.container.statistics.DockerContainerStatistics;
import com.gamedash.daemon.docker.container.statistics.DockerContainerStatisticsCpuUsage;
import com.gamedash.daemon.docker.container.statistics.DockerContainerStatisticsMemoryUsage;
import com.gamedash.daemon.docker.implementation.generic.DockerImpl;
import com.gamedash.daemon.docker.implementation.generic.container.DockerContainerHostConfigImpl;
import com.gamedash.daemon.docker.implementation.generic.container.DockerContainerImplDataLayer;
import com.gamedash.daemon.docker.implementation.generic.container.DockerContainerNetworkImpl;
import com.gamedash.daemon.docker.implementation.generic.container.DockerContainerPortImpl;
import com.gamedash.daemon.docker.implementation.generic.container.event.DockerContainerAsyncEventsListener;
import com.gamedash.daemon.docker.implementation.generic.container.event.DockerContainerEventsImpl;
import com.gamedash.daemon.docker.implementation.generic.container.io.DockerContainerIoImpl;
import com.gamedash.daemon.docker.implementation.generic.container.mount.DockerContainerMountImpl;
import com.gamedash.daemon.docker.implementation.interfaces.IDockerMountImpl;
import com.gamedash.daemon.docker.implementation.interfaces.container.AbstractDockerContainerImpl;
import com.gamedash.daemon.docker.implementation.interfaces.container.IDockerContainerHostConfigImpl;
import com.gamedash.daemon.docker.implementation.interfaces.container.IDockerContainerImpl;
import com.gamedash.daemon.docker.implementation.interfaces.container.IDockerContainerNetworkImpl;
import com.gamedash.daemon.docker.implementation.interfaces.container.IDockerContainerPortImpl;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ContainerMount;
import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.api.model.ContainerNetworkSettings;
import com.github.dockerjava.api.model.ContainerPort;
import com.github.dockerjava.api.model.Statistics;
import java.io.Closeable;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class DockerContainerImpl
extends AbstractDockerContainerImpl {
    public final DockerContainerImplDataLayer dataLayer;
    private final DockerImpl docker;
    private final String id;
    private final DockerContainerIoImpl io;
    private final DockerContainerEventsImpl events;
    private final DockerContainerAsyncEventsListener asyncEventsListener;

    public DockerContainerImpl(DockerImpl docker, String id) {
        this.docker = docker;
        this.id = id;
        this.dataLayer = new DockerContainerImplDataLayer(docker, this);
        this.io = new DockerContainerIoImpl(docker, this);
        this.events = new DockerContainerEventsImpl(docker, this);
        this.asyncEventsListener = new DockerContainerAsyncEventsListener(docker, this);
        this.asyncEventsListener.ensureListening();
        this.getEvents().onStop(() -> this.setIsTerminating(true));
        this.getEvents().onDie(() -> {
            if (!this.isTerminating() && !this.hasTerminated()) {
                this.getCrashManager().queueReport(this.getCrashManager().createReport());
            }
        });
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<String> getNames() throws Exception {
        return (List)this.dataLayer.getValue("names");
    }

    @Override
    public String getImage() throws Exception {
        return (String)this.dataLayer.getValue("image");
    }

    @Override
    public String getImageId() throws Exception {
        return (String)this.dataLayer.getValue("imageId");
    }

    @Override
    public DockerContainerIoImpl getIo() {
        return this.io;
    }

    @Override
    public DockerContainerEventsImpl getEvents() {
        return this.events;
    }

    @Override
    public boolean isRunning() throws Exception {
        for (IDockerContainerImpl container : this.docker.getContainers().getRunning()) {
            if (!container.getId().equals(this.getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<IDockerContainerPortImpl> getPorts() throws Exception {
        ContainerPort[] ports = (ContainerPort[])this.dataLayer.getValue("ports");
        return Arrays.stream(ports).map(DockerContainerPortImpl::new).collect(Collectors.toList());
    }

    @Override
    public void start() throws Exception {
        DockerImpl.getClient().startContainerCmd(this.getId()).exec();
        this.setHasTerminated(false);
    }

    @Override
    public void stop() throws Exception {
        this.setIsTerminating(true);
        try {
            DockerImpl.getClient().stopContainerCmd(this.getId()).exec();
            this.getIo().destroy();
            this.setHasTerminated(true);
        }
        finally {
            this.setIsTerminating(false);
        }
    }

    @Override
    public void kill() throws Exception {
        this.kill("SIGKILL");
    }

    @Override
    public void kill(String signal) throws Exception {
        this.setIsTerminating(true);
        try {
            DockerImpl.getClient().killContainerCmd(this.getId()).withSignal(signal).exec();
            this.getIo().destroy();
            this.setHasTerminated(true);
        }
        finally {
            this.setIsTerminating(false);
        }
    }

    @Override
    public void remove() throws Exception {
        DockerImpl.getClient().removeContainerCmd(this.getId()).exec();
    }

    @Override
    public Map<String, String> getLabels() throws Exception {
        return (Map)this.dataLayer.getValue("labels");
    }

    @Override
    public Long getRootSize() throws Exception {
        return (Long)this.dataLayer.getValue("rootSize");
    }

    public InspectContainerResponse inspect() {
        return DockerImpl.getClient().inspectContainerCmd(this.getId()).exec();
    }

    @Override
    public DockerContainerStatistics queryStatistics() {
        final CompletableFuture future = new CompletableFuture();
        DockerImpl.getClient().statsCmd(this.getId()).withNoStream(true).exec(new ResultCallback<Statistics>(){

            @Override
            public void onStart(Closeable closeable) {
            }

            @Override
            public void onNext(Statistics statistics) {
                future.complete(statistics);
            }

            @Override
            public void onError(Throwable throwable) {
                future.completeExceptionally(throwable);
            }

            @Override
            public void onComplete() {
            }

            @Override
            public void close() {
            }
        });
        Statistics queriedStatistics = (Statistics)future.join();
        DockerContainerStatistics statistics = new DockerContainerStatistics();
        DockerContainerStatisticsCpuUsage cpuUsage = new DockerContainerStatisticsCpuUsage();
        Long totalCpuUsage = queriedStatistics.getCpuStats().getCpuUsage().getTotalUsage();
        Long totalPreCpuUsage = queriedStatistics.getCpuStats().getCpuUsage().getTotalUsage();
        Long systemCpuUsage = queriedStatistics.getCpuStats().getSystemCpuUsage();
        Long systemPreCpuUsage = queriedStatistics.getPreCpuStats().getSystemCpuUsage();
        Long onlineCpus = queriedStatistics.getCpuStats().getOnlineCpus();
        if (totalCpuUsage != null && totalPreCpuUsage != null && systemCpuUsage != null && systemPreCpuUsage != null && onlineCpus != null) {
            Long deltaTotal = totalCpuUsage - totalPreCpuUsage;
            Long deltaSystem = systemCpuUsage - systemPreCpuUsage;
            Long totalUsage = deltaTotal / deltaSystem * onlineCpus * 100L;
            cpuUsage.setUsagePercentage(totalUsage);
        }
        statistics.setCpu(cpuUsage);
        DockerContainerStatisticsMemoryUsage memoryUsage = new DockerContainerStatisticsMemoryUsage();
        memoryUsage.setUsage(queriedStatistics.getMemoryStats().getUsage());
        memoryUsage.setMaxUsage(queriedStatistics.getMemoryStats().getMaxUsage());
        memoryUsage.setLimit(queriedStatistics.getMemoryStats().getLimit());
        statistics.setMemory(memoryUsage);
        return statistics;
    }

    @Override
    public List<IDockerContainerNetworkImpl> getNetworks() throws Exception {
        ArrayList<IDockerContainerNetworkImpl> networks = new ArrayList<IDockerContainerNetworkImpl>();
        ContainerNetworkSettings settings = (ContainerNetworkSettings)this.dataLayer.getValue("networkSettings");
        if (settings != null) {
            settings.getNetworks().forEach((name, networkModel) -> networks.add(new DockerContainerNetworkImpl(this, (String)name, (ContainerNetwork)networkModel)));
        }
        return networks;
    }

    @Override
    public IDockerContainerHostConfigImpl getHostConfig() {
        return new DockerContainerHostConfigImpl(this);
    }

    @Override
    public List<IDockerMountImpl> getMounts() throws Exception {
        List mounts = (List)this.dataLayer.getValue("mounts");
        return mounts.stream().map(model -> new DockerContainerMountImpl(this, (ContainerMount)model)).collect(Collectors.toList());
    }

    @Override
    public Time getTimeStarted() {
        String timeString = this.inspect().getState().getStartedAt();
        if (timeString == null) {
            return null;
        }
        Date date = Date.from(Instant.from(DateTimeFormatter.ISO_INSTANT.parse(timeString)));
        return Time.fromTimestamp(new Timestamp(date.getTime()).getTime() / 1000L);
    }

    @Override
    public Time getTimeCreated() throws Exception {
        return (Time)this.dataLayer.getValue("timeCreated");
    }
}

