/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker.implementation.generic.container;

import com.gamedash.daemon.docker.DockerExposedPort;
import com.gamedash.daemon.docker.DockerHostConfig;
import com.gamedash.daemon.docker.DockerInternetProtocol;
import com.gamedash.daemon.docker.DockerPortBinding;
import com.gamedash.daemon.docker.implementation.generic.DockerImpl;
import com.gamedash.daemon.docker.implementation.generic.container.mount.DockerContainerMountTypeConverter;
import com.gamedash.daemon.docker.implementation.interfaces.container.AbstractDockerContainerBuilder;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Mount;
import com.github.dockerjava.api.model.MountType;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DockerContainerBuilderImpl
extends AbstractDockerContainerBuilder {
    public DockerContainerBuilderImpl(String imageName) {
        super(imageName);
    }

    @Override
    public String build() throws Exception {
        CreateContainerCmd cmd = DockerImpl.getClient().createContainerCmd(this.getImageName());
        if (this.getWorkingDirectory() != null) {
            cmd.withWorkingDir(this.getWorkingDirectory());
        }
        if (this.getEnvironmentVariables() != null) {
            cmd.withEnv(this.getEnvironmentVariablesAsList());
        }
        if (this.getHostName() != null) {
            cmd.withHostName(this.getHostName());
        }
        if (this.getName() != null) {
            cmd.withName(this.getName());
        }
        if (this.getCommand() != null) {
            cmd.withCmd(this.getCommand());
        }
        if (this.getUser() != null) {
            cmd.withUser(this.getUser());
        }
        cmd.withHostConfig(this.createHostConfig());
        cmd.withTty(true);
        cmd.withAttachStderr(true);
        cmd.withAttachStdin(true);
        cmd.withAttachStdout(true);
        cmd.withStdinOpen(true);
        CreateContainerResponse response = cmd.exec();
        String id = response.getId();
        this.registerEntry(id);
        return id;
    }

    private HostConfig createHostConfig() {
        DockerHostConfig receivedHostConfig = this.getHostConfig();
        HostConfig hostConfig = new HostConfig();
        if (receivedHostConfig.getCpuShares() != null) {
            hostConfig.withCpuShares(receivedHostConfig.getCpuShares());
        }
        if (receivedHostConfig.getMemory() != null) {
            hostConfig.withMemory(receivedHostConfig.getMemory());
        }
        if (receivedHostConfig.getMemoryReservation() != null) {
            hostConfig.withMemoryReservation(receivedHostConfig.getMemoryReservation());
        }
        if (receivedHostConfig.getMemorySwap() != null) {
            hostConfig.withMemorySwap(receivedHostConfig.getMemorySwap());
        }
        if (receivedHostConfig.getCpuQuota() != null) {
            hostConfig.withCpuQuota(receivedHostConfig.getCpuQuota());
        }
        if (receivedHostConfig.getCpuPeriod() != null) {
            hostConfig.withCpuPeriod(receivedHostConfig.getCpuPeriod());
        }
        if (receivedHostConfig.getCpuShares() != null) {
            hostConfig.withCpuShares(receivedHostConfig.getCpuShares());
        }
        if (receivedHostConfig.getBlkioWeight() != null) {
            hostConfig.withBlkioWeight(receivedHostConfig.getBlkioWeight());
        }
        if (receivedHostConfig.getOOMKillDisable() != null) {
            hostConfig.withOomKillDisable(receivedHostConfig.getOOMKillDisable());
        }
        if (receivedHostConfig.getNetworkMode() != null) {
            hostConfig.withNetworkMode(receivedHostConfig.getNetworkMode().getName());
        }
        if (receivedHostConfig.getMounts() != null) {
            hostConfig.withMounts(receivedHostConfig.getMounts().stream().map(receivedMount -> {
                MountType mountType;
                Mount mount = new Mount();
                mount.withSource(receivedMount.getSource());
                mount.withTarget(receivedMount.getTarget());
                mount.withReadOnly(receivedMount.getReadOnly());
                if (receivedMount.getType() != null && (mountType = DockerContainerMountTypeConverter.convert(receivedMount.getType())) != null) {
                    mount.withType(mountType);
                }
                return mount;
            }).collect(Collectors.toList()));
        }
        hostConfig.withPortBindings(this.createPortBindings());
        hostConfig.withDns("8.8.8.8", "8.8.4.4");
        hostConfig.withOomKillDisable(false);
        return hostConfig;
    }

    private ExposedPort createExposedPort(DockerExposedPort dockerExposedPort) {
        if (dockerExposedPort.getInternetProtocol() == DockerInternetProtocol.TCP) {
            return ExposedPort.tcp(dockerExposedPort.getPort());
        }
        if (dockerExposedPort.getInternetProtocol() == DockerInternetProtocol.UDP) {
            return ExposedPort.udp(dockerExposedPort.getPort());
        }
        if (dockerExposedPort.getInternetProtocol() == DockerInternetProtocol.SCTP) {
            return ExposedPort.sctp(dockerExposedPort.getPort());
        }
        return null;
    }

    private List<PortBinding> createPortBindings() {
        ArrayList<PortBinding> portBindings = new ArrayList<PortBinding>();
        for (DockerPortBinding dockerPortBinding : this.getHostConfig().getPortBindings()) {
            PortBinding portBinding = new PortBinding(Ports.Binding.bindPort(dockerPortBinding.getPort()), this.createExposedPort(dockerPortBinding.getExposedPort()));
            portBindings.add(portBinding);
        }
        return portBindings;
    }
}

