/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker.image;

import com.gamedash.daemon.docker.Docker;
import com.gamedash.daemon.docker.image.DockerImage;
import com.gamedash.daemon.docker.implementation.interfaces.image.IDockerImageImpl;
import java.util.ArrayList;
import java.util.List;

public class DockerImages {
    private final Docker docker;

    public DockerImages(Docker docker) {
        this.docker = docker;
    }

    public List<DockerImage> getAll() {
        ArrayList<DockerImage> images = new ArrayList<DockerImage>();
        for (IDockerImageImpl implementation : this.docker.getImplementation().getImages().getAll()) {
            images.add(new DockerImage(this.docker, implementation));
        }
        return images;
    }

    public List<DockerImage> getRunning() {
        ArrayList<DockerImage> images = new ArrayList<DockerImage>();
        for (IDockerImageImpl implementation : this.docker.getImplementation().getImages().getRunning()) {
            images.add(new DockerImage(this.docker, implementation));
        }
        return images;
    }

    public DockerImage get(String id) {
        for (DockerImage image : this.getAll()) {
            if (!image.getId().equals(id)) continue;
            return image;
        }
        return null;
    }

    public boolean exists(String id) {
        return this.get(id) != null;
    }
}

