/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker.container.registry;

import com.gamedash.daemon.docker.container.DockerContainer;
import com.gamedash.daemon.docker.container.registry.DockerContainerRegistryEntry;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class DockerContainerRegistryFile {
    private static final Gson gson = new Gson();
    private final File file;
    private volatile List<DockerContainerRegistryEntry> entries = new ArrayList<DockerContainerRegistryEntry>();

    public DockerContainerRegistryFile(File file) throws Exception {
        this.file = file;
        this.populate();
    }

    public File getFile() {
        return this.file;
    }

    public void addEntry(DockerContainer container) throws Exception {
        this.addEntry(DockerContainerRegistryEntry.fromContainer(container));
    }

    public void addEntry(DockerContainerRegistryEntry entry) {
        this.getEntries().add(entry);
    }

    public DockerContainerRegistryEntry getEntry(DockerContainer container) {
        Optional<DockerContainerRegistryEntry> result = this.getEntries().stream().filter(entry -> entry.getId().equals(container.getId())).findFirst();
        return result.orElse(null);
    }

    public void removeEntry(DockerContainer container) {
        this.getEntries().removeIf(entry -> entry.getId().equals(container.getId()));
    }

    public synchronized void commit() throws IOException {
        FileUtils.writeStringToFile(this.file, gson.toJson(this.getEntries()), StandardCharsets.UTF_8);
    }

    public void populate() throws Exception {
        try (FileInputStream inputStream = new FileInputStream(this.file);){
            DockerContainerRegistryEntry[] entriesArray = gson.fromJson(IOUtils.toString((InputStream)inputStream, StandardCharsets.UTF_8), DockerContainerRegistryEntry[].class);
            if (entriesArray != null) {
                this.setEntries(new ArrayList<DockerContainerRegistryEntry>(Arrays.asList(entriesArray)));
            }
        }
    }

    public File toFile() {
        return this.file;
    }

    public List<DockerContainerRegistryEntry> getEntries() {
        return this.entries;
    }

    private void setEntries(List<DockerContainerRegistryEntry> entries) {
        this.entries = entries;
    }

    private void clearEntries() {
        this.entries = new ArrayList<DockerContainerRegistryEntry>();
    }
}

