/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker.container.io.listener;

import com.gamedash.daemon.common.cache.CachedValue;
import com.gamedash.daemon.common.relay.server.channel.RelayChannel;
import com.gamedash.daemon.common.relay.server.message.RelayMessage;
import com.gamedash.daemon.docker.container.DockerContainer;
import com.gamedash.daemon.docker.container.io.DockerContainerIOOutputItem;
import com.gamedash.daemon.docker.container.io.listener.AbstractDockerContainerIOListener;
import com.gamedash.daemon.docker.container.io.listener.DockerContainerRelayOutputItem;
import com.gamedash.daemon.relay.server.RelayServer;
import com.gamedash.daemon.relay.server.RelayServers;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;

public class DockerContainerRelayIOListener
extends AbstractDockerContainerIOListener {
    private final CachedValue<RelayServer> server = new CachedValue();
    private final DockerContainer container;
    private final List<String> channels = new CopyOnWriteArrayList<String>();

    public DockerContainerRelayIOListener(DockerContainer container) {
        this(container, new ArrayList<String>());
    }

    public DockerContainerRelayIOListener(DockerContainer container, List<String> channels) {
        this.container = container;
        this.channels.addAll(channels);
    }

    @Override
    public void onOutput(DockerContainerIOOutputItem item) throws Exception {
        DockerContainerRelayOutputItem outputItem = new DockerContainerRelayOutputItem(item);
        outputItem.setSourceName("docker");
        for (RelayChannel channel : this.getChannels()) {
            channel.broadcast(new RelayMessage<DockerContainerRelayOutputItem>("container.io.output", outputItem));
        }
    }

    public List<RelayChannel> getChannels() throws Exception {
        RelayServer server = this.getServer();
        return this.channels.stream().map(name -> server.getChannels().acquire((String)name)).collect(Collectors.toList());
    }

    public synchronized void addChannel(String name) throws Exception {
        if (!this.hasChannel(name)) {
            this.channels.add(name);
        }
    }

    public boolean hasChannel(String name) throws Exception {
        for (RelayChannel channel : this.getChannels()) {
            if (!channel.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public void addChannel(RelayChannel channel) {
        this.channels.add(channel.getName());
    }

    public RelayServer getServer() throws Exception {
        return this.server.handle(RelayServers::getPrimaryInstance);
    }
}

