/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker.container;

import com.gamedash.daemon.docker.Docker;
import com.gamedash.daemon.docker.container.DockerContainer;
import com.gamedash.daemon.docker.container.IDockerContainerBuilder;
import java.util.List;
import java.util.stream.Collectors;

public class DockerContainers {
    private final Docker docker;

    public DockerContainers(Docker docker) {
        this.docker = docker;
    }

    public List<DockerContainer> getAll() throws Exception {
        return this.docker.getImplementation().getContainers().getAll().stream().map(DockerContainer::new).collect(Collectors.toList());
    }

    public List<DockerContainer> getRunning() throws Exception {
        return this.docker.getImplementation().getContainers().getRunning().stream().map(DockerContainer::new).collect(Collectors.toList());
    }

    public IDockerContainerBuilder create(String imageName) throws Exception {
        return this.docker.getImplementation().getContainers().create(imageName);
    }

    public boolean exists(String id) throws Exception {
        for (DockerContainer container : this.getAll()) {
            if (!container.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public DockerContainer get(String id) throws Exception {
        for (DockerContainer container : this.getAll()) {
            if (!container.getId().equals(id)) continue;
            return container;
        }
        return null;
    }
}

