/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker;

import com.gamedash.daemon.docker.DockerInternetProtocol;

public class DockerExposedPort {
    private final int port;
    private final DockerInternetProtocol internetProtocol;

    public DockerExposedPort(int port, DockerInternetProtocol internetProtocol) {
        this.port = port;
        this.internetProtocol = internetProtocol;
    }

    public int getPort() {
        return this.port;
    }

    public DockerInternetProtocol getInternetProtocol() {
        return this.internetProtocol;
    }

    public static DockerExposedPort create(int port, String protocol) {
        return new DockerExposedPort(port, DockerInternetProtocol.fromString(protocol));
    }

    public static DockerExposedPort createTCP(int port) {
        return new DockerExposedPort(port, DockerInternetProtocol.TCP);
    }

    public static DockerExposedPort createUDP(int port) {
        return new DockerExposedPort(port, DockerInternetProtocol.UDP);
    }

    public static DockerExposedPort createSCTP(int port) {
        return new DockerExposedPort(port, DockerInternetProtocol.SCTP);
    }
}

