/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker;

import com.gamedash.daemon.docker.container.DockerContainers;
import com.gamedash.daemon.docker.image.DockerImages;
import com.gamedash.daemon.docker.implementation.generic.DockerImpl;
import com.gamedash.daemon.docker.implementation.interfaces.IDockerImpl;
import com.gamedash.daemon.docker.repository.DockerRepositories;
import com.gamedash.daemon.docker.status.DockerStatus;
import java.util.HashMap;
import java.util.Map;

public class Docker {
    private static final Map<String, Docker> instances = new HashMap<String, Docker>();
    private final IDockerImpl implementation;
    private final DockerContainers containers;
    private final DockerRepositories repositories;
    private final DockerImages images;
    private final DockerStatus status;

    public Docker(IDockerImpl implementation) {
        this.implementation = implementation;
        this.containers = new DockerContainers(this);
        this.repositories = new DockerRepositories(this);
        this.images = new DockerImages(this);
        this.status = new DockerStatus(this);
    }

    public IDockerImpl getImplementation() {
        return this.implementation;
    }

    public DockerContainers getContainers() {
        return this.containers;
    }

    public DockerRepositories getRepositories() {
        return this.repositories;
    }

    public DockerStatus getStatus() {
        return this.status;
    }

    public DockerImages getImages() {
        return this.images;
    }

    public static synchronized Docker getInstance() {
        return Docker.getInstance(new DockerImpl());
    }

    public static synchronized Docker getInstance(IDockerImpl implementation) {
        String key = implementation.getClass().getCanonicalName();
        if (!instances.containsKey(key)) {
            instances.put(key, new Docker(implementation));
        }
        return instances.get(key);
    }

    public static Docker createInstance(IDockerImpl implementation) {
        return new Docker(implementation);
    }
}

