/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.dependency.dependencies;

import com.gamedash.daemon.dependency.DependencyAnnotation;
import com.gamedash.daemon.dependency.dependencies.AbstractDependency;
import com.gamedash.daemon.dependency.install.IInstallerManagerProgressCallback;
import com.gamedash.daemon.packageManager.PackageManager;
import com.gamedash.daemon.packageManager.platform.IPackageManagerPlatformPackage;
import com.gamedash.daemon.platform.linux.packageManager.packages.LinuxPackageException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DependencyAnnotation(name="LinuxPrerequisites")
public class LinuxPrerequisites
extends AbstractDependency {
    public static final Logger logger = LoggerFactory.getLogger(LinuxPrerequisites.class);
    private final List<IPackageManagerPlatformPackage> packages = new ArrayList<IPackageManagerPlatformPackage>(){
        {
            this.add(PackageManager.get("apt-transport-https"));
            this.add(PackageManager.get("ca-certificates"));
            this.add(PackageManager.get("curl"));
            this.add(PackageManager.get("gnupg-agent"));
            this.add(PackageManager.get("software-properties-common"));
        }
    };

    @Override
    public void install(IInstallerManagerProgressCallback callback) throws Exception {
        for (IPackageManagerPlatformPackage platformPackage : this.getPackages()) {
            try {
                platformPackage.install();
            }
            catch (LinuxPackageException e) {
                logger.error(ExceptionUtils.getStackTrace(e));
            }
        }
    }

    @Override
    public void uninstall(IInstallerManagerProgressCallback callback) throws Exception {
        for (IPackageManagerPlatformPackage platformPackage : this.getPackages()) {
            platformPackage.uninstall();
        }
    }

    @Override
    public boolean isAvailable() {
        return SystemUtils.IS_OS_LINUX;
    }

    public List<IPackageManagerPlatformPackage> getPackages() {
        return this.packages;
    }

    public void add(IPackageManagerPlatformPackage _package) {
        this.packages.add(_package);
    }
}

