/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.relay.server.listener.registry;

import com.gamedash.daemon.common.relay.server.RelayServer;
import com.gamedash.daemon.common.relay.server.listener.AddChannelListener;
import com.gamedash.daemon.common.relay.server.listener.ChannelExistsListener;
import com.gamedash.daemon.common.relay.server.listener.GetChannelsListener;
import com.gamedash.daemon.common.relay.server.listener.IListener;
import com.gamedash.daemon.common.relay.server.listener.RemoveChannelsListener;
import com.gamedash.daemon.common.relay.server.listener.registry.RegisteredListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ListenersRegistry {
    private final RelayServer server;
    private final List<RegisteredListener> listeners = new ArrayList<RegisteredListener>();

    public ListenersRegistry(RelayServer server) {
        this.server = server;
        this.registerDefaultListeners();
    }

    public void listen() {
        for (RegisteredListener registeredListener : this.getListeners()) {
            registeredListener.getListener().listen();
        }
    }

    public List<RegisteredListener> getListening() {
        return this.getListeners().stream().filter(listener -> this.isListening(listener.getListener().getClass())).collect(Collectors.toList());
    }

    public boolean isListening(Class<? extends IListener> listenerClass) {
        for (RegisteredListener registeredListener : this.getListening()) {
            if (!registeredListener.getListener().getClass().equals(listenerClass)) continue;
            return true;
        }
        return false;
    }

    public List<RegisteredListener> getListeners() {
        return this.listeners;
    }

    public RegisteredListener getListener(String name) {
        Optional<RegisteredListener> listener = this.getListeners().stream().filter(_listener -> _listener.getName().equals(name)).findFirst();
        return listener.orElse(null);
    }

    public void removeListener(RegisteredListener listener) {
        this.listeners.remove(listener);
    }

    public void removeListener(String name) {
        RegisteredListener listener = this.getListener(name);
        if (listener != null) {
            this.removeListener(listener);
        }
    }

    public void registerListener(String name, IListener listener) {
        if (this.getListener(name) != null) {
            this.removeListener(name);
        }
        this.listeners.add(new RegisteredListener(this.server, name, listener));
    }

    private void registerDefaultListeners() {
        this.registerListener("addChannel", new AddChannelListener(this.server));
        this.registerListener("channelExists", new ChannelExistsListener(this.server));
        this.registerListener("getChannels", new GetChannelsListener(this.server));
        this.registerListener("removeChannels", new RemoveChannelsListener(this.server));
    }
}

