/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.relay.server.listener;

import com.gamedash.daemon.common.relay.server.RelayServer;
import com.gamedash.daemon.common.relay.server.channel.RelayChannel;
import com.gamedash.daemon.common.relay.server.client.RelayClient;
import com.gamedash.daemon.common.relay.server.listener.IListener;
import com.gamedash.daemon.common.relay.server.message.payload.ErrorPayload;
import com.gamedash.daemon.common.relay.server.message.payload.SuccessPayload;

public class AddChannelListener
implements IListener {
    private final RelayServer server;

    public AddChannelListener(RelayServer server) {
        this.server = server;
    }

    @Override
    public void listen() {
        this.server.getApi().addEventListener("addChannel", Input.class, (socketIoClient, input, ackSender) -> {
            String channelName = input.getName();
            RelayChannel channel = this.server.getChannels().acquire(channelName);
            RelayClient client = this.server.getClients().get(socketIoClient.getSessionId());
            if (channel.getClients().has(client.getId())) {
                ackSender.sendAckData(new ErrorPayload("Already added to channel " + channelName));
            }
            channel.getClients().add(client);
            ackSender.sendAckData(new SuccessPayload("Successfully added to channel " + channelName));
        });
    }

    public static class Input {
        private String name;

        public String getName() {
            return this.name;
        }
    }
}

