/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.relay.server.channel;

import com.gamedash.daemon.common.relay.server.RelayServer;
import com.gamedash.daemon.common.relay.server.channel.RelayChannel;
import com.gamedash.daemon.common.relay.server.client.RelayClient;
import io.netty.channel.ChannelException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;

public class RelayChannelClientsDirectory {
    private final RelayServer server;
    private final RelayChannel channel;
    private final List<UUID> clients = new CopyOnWriteArrayList<UUID>();

    public RelayChannelClientsDirectory(RelayServer server, RelayChannel channel) {
        this.server = server;
        this.channel = channel;
    }

    public List<RelayClient> getAll() {
        return this.clients.stream().map(id -> this.server.getClients().get((UUID)id)).collect(Collectors.toList());
    }

    public void add(UUID id) {
        if (this.has(id)) {
            throw new ChannelException("Client already added");
        }
        this.clients.add(id);
    }

    public void add(RelayClient client) {
        this.add(client.getId());
    }

    public void remove(UUID id) {
        this.clients.remove(id);
    }

    public boolean has(UUID id) {
        return this.clients.contains(id);
    }
}

