/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.license;

import com.gamedash.daemon.common.api.client.ApiClient;
import com.gamedash.daemon.common.api.client.ApiQuery;
import com.gamedash.daemon.common.api.client.response.QueryResponse;
import com.gamedash.daemon.common.cache.CachedValue;
import com.gamedash.daemon.common.license.License;
import com.gamedash.daemon.common.license.LicenseHash;
import com.gamedash.daemon.common.license.current.CurrentLicense;
import com.gamedash.daemon.common.singleton.SingletonList;
import com.google.gson.JsonObject;

public class Licenses {
    private static final CachedValue<CurrentLicense> current = new CachedValue();
    private static final SingletonList<License> licenses = new SingletonList<License>(){

        @Override
        public boolean compare(License a, License b) {
            return a.compareTo(b) == 0;
        }
    };

    public static CurrentLicense getCurrent() throws Exception {
        return current.handle(() -> {
            ApiQuery query = ApiClient.createQuery("infrastructure/node/daemon/license");
            QueryResponse response = query.get();
            JsonObject result = response.getJsonObject().get("response").getAsJsonObject();
            String hash = result.get("hash").getAsString();
            CurrentLicense license = new CurrentLicense(LicenseHash.create(hash));
            license.dataLayer.setValue("syncHasTimedOut", result.get("syncHasTimedOut").getAsBoolean());
            return license;
        });
    }

    public static License get(LicenseHash hash) {
        return licenses.handle(license -> license.getHash().compareTo(hash) == 0, () -> new License(hash));
    }
}

