/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.config;

import com.gamedash.daemon.common.config.ConfigException;
import com.gamedash.daemon.common.config.ConfigFile;
import com.gamedash.daemon.common.config.ConfigFileNotFoundException;
import com.gamedash.daemon.common.fileSystem.FileSystem;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger logger = LoggerFactory.getLogger(Config.class);
    private static final List<ConfigFile> files = new ArrayList<ConfigFile>();
    private static ConfigFile defaultFile;

    public static ConfigFile getDefaultFile() {
        try {
            if (defaultFile == null) {
                defaultFile = Config.getFile("default.properties");
                return defaultFile;
            }
            return defaultFile;
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace(e));
            return null;
        }
    }

    public static void setDefaultFile(ConfigFile file) {
        if (!file.toFile().exists()) {
            throw new ConfigFileNotFoundException("Can not set config file to " + file.toFile().getPath() + " as default because it does not exist");
        }
        defaultFile = file;
    }

    public static List<ConfigFile> getFiles() {
        return files;
    }

    public static void reloadFiles() {
        for (ConfigFile file : Config.getFiles()) {
            file.reload();
        }
    }

    public static synchronized ConfigFile getFile(String path) throws IOException {
        ConfigFile configFile2;
        Path resolvedPath = Config.resolvePath(path);
        for (ConfigFile configFile2 : files) {
            if (!configFile2.getFile().toPath().equals(resolvedPath)) continue;
            return configFile2;
        }
        File file = new File(resolvedPath.toString());
        if (!file.exists()) {
            Config.createFile(resolvedPath);
        }
        configFile2 = new ConfigFile(file);
        files.add(configFile2);
        return configFile2;
    }

    public static boolean fileExists(String path) {
        return new File(path).exists();
    }

    public static void createFile(String path) throws IOException, ConfigException {
        Config.createFile(Paths.get(path, new String[0]));
    }

    public static void createFile(Path path) throws IOException, ConfigException {
        File file = new File(path.toString());
        if (file.exists()) {
            throw new IOException("File " + path + " already exists");
        }
        file.createNewFile();
    }

    private static Path resolvePath(String path) {
        return Config.resolvePath(Paths.get(path, new String[0]));
    }

    private static Path resolvePath(Path path) {
        Path rootPath = Paths.get(FileSystem.getRootDirectory().toString(), new String[0]);
        return rootPath.resolve(path);
    }
}

