/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.api.server.route.manager;

import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.request.input.parameter.RequestParameterException;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.IRouteBefore;
import com.gamedash.daemon.common.api.server.route.Route;
import java.lang.reflect.Constructor;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spark.ResponseTransformer;
import spark.ResponseTransformerRouteImpl;
import spark.RouteImpl;
import spark.Service;
import spark.route.HttpMethod;

public class RoutesManagerRoute {
    public static final Logger logger = LoggerFactory.getLogger(RoutesManagerRoute.class);
    private final HttpMethod method;
    private final String[] endpoints;
    private final String acceptType;
    private final ResponseTransformer responseTransformer;
    private final Class<? extends Route<?>> routeClass;
    private IRouteBefore before;

    public RoutesManagerRoute(HttpMethod method, String[] endpoints, String acceptType, Class<? extends Route<?>> routeClass, ResponseTransformer responseTransformer) {
        this.method = method;
        this.endpoints = endpoints;
        this.acceptType = acceptType;
        this.routeClass = routeClass;
        this.responseTransformer = responseTransformer;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String[] getEndpoints() {
        return this.endpoints;
    }

    public String getAcceptType() {
        return this.acceptType;
    }

    public Route<?> createRouteInstance(Request request, Response response) throws Exception {
        Constructor<Route<?>> constructor = this.routeClass.getConstructor(Request.class, Response.class);
        return constructor.newInstance(request, response);
    }

    public ResponseTransformer getResponseTransformer() {
        return this.responseTransformer;
    }

    public void before(IRouteBefore before) {
        this.before = before;
    }

    public void invokeBefore(Request request, Response response) throws Exception {
        if (this.before != null) {
            this.before.method(request, response);
        }
    }

    public void registerWithService(Service service) {
        for (String endpoint : this.getEndpoints()) {
            this.registerEndpointWithService(endpoint, service);
        }
    }

    private void registerEndpointWithService(String endpoint, Service service) {
        spark.Route sparkRoute = (sparkRequest, sparkResponse) -> {
            Object result;
            Request request = new Request(sparkRequest);
            Response response = new Response(sparkResponse);
            try {
                this.invokeBefore(request, response);
                Route<?> route = this.createRouteInstance(request, response);
                for (String name : route.getRequiredParameters()) {
                    if (request.getInput().getParameters().exists(name)) continue;
                    throw new RequestParameterException("Parameter \"" + name + "\" is required");
                }
                route.before();
                result = route.execute();
                route.after();
                if (result == null) {
                    response.setStatusCode(204);
                    return "";
                }
            }
            catch (Exception e) {
                logger.error("Encountered exception thrown on route " + request.getMethod() + " " + request.getUrl() + ": " + ExceptionUtils.getStackTrace(e));
                throw e;
            }
            return result;
        };
        RouteImpl sparkRouteImplementation = this.getResponseTransformer() != null ? ResponseTransformerRouteImpl.create(endpoint, this.getAcceptType(), sparkRoute, this.getResponseTransformer()) : RouteImpl.create(endpoint, this.getAcceptType(), sparkRoute);
        service.addRoute(this.getMethod(), sparkRouteImplementation);
    }
}

