/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.api.client.response.logger;

import com.gamedash.daemon.common.api.client.ApiClient;
import com.gamedash.daemon.common.api.client.ApiQuery;
import com.gamedash.daemon.common.api.client.response.QueryResponse;
import com.gamedash.daemon.common.api.client.response.logger.QueryResponseLoggerAlreadyListening;
import com.google.gson.Gson;
import java.text.MessageFormat;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryResponseLogger {
    public static final Logger logger = LoggerFactory.getLogger(QueryResponseLogger.class);
    private static boolean isListening = false;

    public static void listen() {
        if (QueryResponseLogger.isListening()) {
            throw new QueryResponseLoggerAlreadyListening("Logger already listening");
        }
        ApiClient.onResponse((query, response) -> {
            try {
                QueryResponseLogger.log(query, response);
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace(e));
            }
        });
        QueryResponseLogger.setIsListening(true);
    }

    public static void log(ApiQuery query, QueryResponse response) throws Exception {
        Gson gson = new Gson();
        String body = response.getRaw();
        if (response.isJson()) {
            body = gson.toJson(response.getJsonObject());
        }
        logger.info(MessageFormat.format("API client request {0} returned response with status code {1} and body {2}", query.getAddress(), response.getStatusCode(), body));
    }

    public static boolean isListening() {
        return isListening;
    }

    private static void setIsListening(boolean listening) {
        isListening = listening;
    }
}

