/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.system.os.fileSystem.fileStore;

import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.fileSystem.path.PathUtils;
import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import oshi.SystemInfo;
import oshi.software.os.OSFileStore;

public class GetFileStoreForPath
extends Route<StoreResult> {
    private final SystemInfo systemInfo = new SystemInfo();
    private String path;

    public GetFileStoreForPath(Request request, Response response) {
        super(request, response);
    }

    @Override
    public StoreResult execute() throws Exception {
        this.path = PathUtils.fromBase64(this.request.getInput().getParameters().get("path").getValue());
        OSFileStore fileStore = this.getFileStore();
        if (fileStore == null) {
            return null;
        }
        StoreResult storeResult = new StoreResult();
        storeResult.name = fileStore.getName();
        storeResult.uuid = fileStore.getUUID();
        storeResult.freeInodes = fileStore.getFreeInodes();
        storeResult.freeSpace = fileStore.getFreeSpace();
        storeResult.totalSpace = fileStore.getTotalSpace();
        storeResult.usableSpace = fileStore.getUsableSpace();
        storeResult.logicalVolume = fileStore.getLogicalVolume();
        storeResult.mount = fileStore.getMount();
        return storeResult;
    }

    private OSFileStore getFileStore() {
        List<String> pathBits = Arrays.asList(StringUtils.split(this.path, File.pathSeparator));
        for (int i = 0; i < pathBits.size() + 1; ++i) {
            String path = String.join((CharSequence)File.pathSeparator, pathBits.subList(0, pathBits.size() - i));
            if (path.isEmpty()) {
                path = "/";
            }
            for (OSFileStore fileStore : this.systemInfo.getOperatingSystem().getFileSystem().getFileStores()) {
                if (!fileStore.getMount().equalsIgnoreCase(path)) continue;
                return fileStore;
            }
        }
        return null;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"path"};
    }

    static class StoreResult {
        @SerializedName(value="name")
        public String name;
        @SerializedName(value="uuid")
        public String uuid;
        @SerializedName(value="freeInodes")
        public long freeInodes;
        @SerializedName(value="freeSpace")
        public long freeSpace;
        @SerializedName(value="usableSpace")
        public long usableSpace;
        @SerializedName(value="totalSpace")
        public long totalSpace;
        @SerializedName(value="logicalVolume")
        public String logicalVolume;
        @SerializedName(value="mount")
        public String mount;

        StoreResult() {
        }
    }
}

