/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.process.childprocess;

import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.process.Processes;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcessNotFoundException;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class GetChildProcessDescendants
extends Route<List<?>> {
    private int id;

    public GetChildProcessDescendants(Request request, Response response) throws Exception {
        super(request, response);
        this.id = Integer.parseInt(this.request.getInput().getParameters().get("id").getValue());
    }

    @Override
    public List<DescendantResult> execute() throws Exception {
        ChildProcess process = ChildProcesses.get(this.id);
        ArrayList<DescendantResult> results = new ArrayList<DescendantResult>();
        for (ProcessHandle processHandle : process.getDescendants()) {
            results.add(new DescendantResult(processHandle));
        }
        return results;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"id"};
    }

    @Override
    public void before() throws Exception {
        if (!Processes.exists(this.id)) {
            throw new ChildProcessNotFoundException("Process does not exist");
        }
    }

    private static class DescendantResult {
        private long id;
        private boolean isAlive;
        private Long parentId;
        private String command;
        private String commandLine;
        private String[] arguments;
        private String user;

        public DescendantResult(ProcessHandle processHandle) {
            Optional<ProcessHandle> parent = processHandle.parent();
            this.id = processHandle.pid();
            this.isAlive = processHandle.isAlive();
            if (parent.isPresent()) {
                this.parentId = parent.get().pid();
                ProcessHandle.Info info = parent.get().info();
                this.command = info.command().orElse(null);
                this.commandLine = info.commandLine().orElse(null);
                this.arguments = info.arguments().orElse(null);
                this.user = info.user().orElse(null);
            }
        }
    }
}

