/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.process;

import com.gamedash.daemon.api.server.request.input.parameter.transformer.IntegerRequestParameterTransformer;
import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.Processes;
import com.google.gson.annotations.SerializedName;

public class GetProcess
extends Route<Object> {
    private int id;

    public GetProcess(Request request, Response response) throws Exception {
        super(request, response);
        this.id = this.request.getInput().getParameters().get("id").getValue(new IntegerRequestParameterTransformer());
    }

    @Override
    public ResponseProcess execute() throws Exception {
        IProcess process = Processes.get(this.id);
        return new ResponseProcess(process);
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"id"};
    }

    private static class ResponseProcess {
        @SerializedName(value="id")
        private int id;
        @SerializedName(value="name")
        private String name;
        @SerializedName(value="commandLine")
        private String[] commandLine;
        @SerializedName(value="workingDirectory")
        private String workingDirectory;
        @SerializedName(value="isSelf")
        private boolean isSelf;

        public ResponseProcess(IProcess process) throws Exception {
            this.id = process.getId();
            this.name = process.getName();
            this.commandLine = process.getCommandLine();
            this.workingDirectory = process.getWorkingDirectory().toString();
            this.isSelf = process.isSelf();
        }
    }
}

