/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file.upload;

import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.fileSystem.file.upload.session.Session;
import com.gamedash.daemon.fileSystem.file.upload.session.Sessions;
import com.gamedash.daemon.fileSystem.file.upload.session.chunk.Chunk;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class GetSession
extends Route<Object> {
    public GetSession(Request request, Response response) {
        super(request, response);
    }

    @Override
    public Result execute() throws Exception {
        UUID sessionId = UUID.fromString(this.request.getInput().getParameters().get("session_id").getValue());
        if (!Sessions.exists(sessionId)) {
            throw new Exception("Session does not exist");
        }
        Session session = Sessions.get(sessionId);
        Result result = new Result(session);
        for (Chunk chunk : session.getChunks().getAll()) {
            result.chunks.add(new ResultChunk(chunk));
        }
        return result;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"session_id"};
    }

    private static class ResultChunk {
        @SerializedName(value="id")
        private long id;
        @SerializedName(value="hasReceived")
        private boolean hasReceived;

        public ResultChunk(Chunk chunk) {
            this.id = chunk.getId();
            this.hasReceived = chunk.hasReceived();
        }
    }

    private static class Result {
        @SerializedName(value="chunks")
        public List<ResultChunk> chunks = new ArrayList<ResultChunk>();
        @SerializedName(value="chunkCount")
        public long chunkCount;
        @SerializedName(value="chunkSize")
        public long chunkSize;
        @SerializedName(value="destination")
        public String destination;

        public Result(Session session) {
            this.chunkCount = session.getChunkCount();
            this.chunkSize = session.getChunkSize();
            this.destination = session.getDestination().getAbsolutePath();
        }
    }
}

