/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file;

import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.fileSystem.file.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Read
extends Route<Response> {
    public Read(Request request, Response response) {
        super(request, response);
    }

    @Override
    public Response execute() throws Exception {
        File file = FileUtils.fromBase64(this.request.getInput().getParameters().get("path").getValue());
        if (!file.exists() || !file.isFile()) {
            throw new IOException("File does not exist");
        }
        try (OutputStream outputStream = this.response.getRaw();
             FileInputStream fileInputStream = new FileInputStream(file);){
            fileInputStream.transferTo(outputStream);
            outputStream.flush();
        }
        return this.response;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"path"};
    }
}

