/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.fileSystem.file;

import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.fileSystem.file.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;

public class Append
extends Route<String> {
    public Append(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        File file = FileUtils.fromBase64(this.request.getInput().getParameters().get("path").getValue());
        if (!file.exists() || file.isDirectory()) {
            throw new FileNotFoundException("File does not exist");
        }
        List<File> sources = this.getSources();
        for (File source : sources) {
            if (source.exists() && !source.isDirectory()) continue;
            throw new FileNotFoundException("Source file " + source.getPath() + " does not exist");
        }
        try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(file));){
            for (File source : sources) {
                try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(source));){
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
            }
        }
        return null;
    }

    private List<File> getSources() {
        ArrayList<File> sources = new ArrayList<File>();
        for (String pathString : this.request.getInput().getParameters().get("sources").getList()) {
            sources.add(FileUtils.fromBase64(pathString));
        }
        return sources;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"path", "sources"};
    }
}

