/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.docker.repository.image;

import com.gamedash.daemon.api.server.model.docker.repository.image.DockerRepositoryImageModel;
import com.gamedash.daemon.api.server.request.input.parameter.transformer.Base64RequestParameterTransformer;
import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.request.input.parameter.RequestParameterException;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.docker.Docker;
import com.gamedash.daemon.docker.repository.DockerRepository;
import com.gamedash.daemon.docker.repository.image.DockerRepositoryImage;
import java.util.List;
import java.util.stream.Collectors;

public class GetImagesByTag
extends Route<List<DockerRepositoryImageModel>> {
    private final Docker docker = Docker.getInstance();

    public GetImagesByTag(Request request, Response response) {
        super(request, response);
    }

    @Override
    public List<DockerRepositoryImageModel> execute() throws Exception {
        List<DockerRepositoryImage> images = this.getImages();
        return images.stream().map(DockerRepositoryImageModel::new).collect(Collectors.toList());
    }

    private DockerRepository getRepository() {
        String repositoryId = this.request.getInput().getParameters().get("repository_name").getValue(new Base64RequestParameterTransformer());
        return this.docker.getRepositories().get(repositoryId);
    }

    private List<DockerRepositoryImage> getImages() throws RequestParameterException {
        DockerRepository repository = this.getRepository();
        String tag = this.getImageTag();
        return repository.getImages().getByTag(tag);
    }

    private String getImageTag() throws RequestParameterException {
        return this.request.getInput().getParameters().exists("image_tag") ? this.request.getInput().getParameters().get("image_tag").getValue() : null;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"repository_name", "image_tag"};
    }
}

