/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.docker.container.io;

import com.gamedash.daemon.api.server.helpers.docker.container.DockerContainerHelpers;
import com.gamedash.daemon.api.server.model.docker.container.io.DockerContainerIoOutputItemModel;
import com.gamedash.daemon.api.server.request.input.parameter.transformer.IntegerRequestParameterTransformer;
import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.docker.Docker;
import com.gamedash.daemon.docker.container.DockerContainer;
import com.gamedash.daemon.docker.container.io.DockerContainerIOOutputItem;
import java.util.List;
import java.util.stream.Collectors;

public class GetOutput
extends Route<List<DockerContainerIoOutputItemModel>> {
    private final Docker docker = Docker.getInstance();

    public GetOutput(Request request, Response response) {
        super(request, response);
    }

    @Override
    public List<DockerContainerIoOutputItemModel> execute() throws Exception {
        DockerContainer container = this.docker.getContainers().get(this.request.getInput().getParameters().get("container_id").getValue());
        List<DockerContainerIOOutputItem> items = container.getIo().getOutput(this.getTail());
        return items.stream().map(DockerContainerIoOutputItemModel::new).collect(Collectors.toList());
    }

    private Integer getTail() {
        if (this.request.getInput().getParameters().exists("tail")) {
            return this.request.getInput().getParameters().get("tail").getValue(new IntegerRequestParameterTransformer());
        }
        return null;
    }

    @Override
    public void before() throws Exception {
        String id = this.request.getInput().getParameters().get("container_id").getValue();
        DockerContainerHelpers.ensureExists(id);
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"container_id"};
    }
}

