/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.route.routes.docker.container;

import com.gamedash.daemon.api.server.request.input.parameter.transformer.BooleanRequestParameterTransformer;
import com.gamedash.daemon.api.server.request.input.parameter.transformer.IntegerRequestParameterTransformer;
import com.gamedash.daemon.api.server.request.input.parameter.transformer.LongRequestParameterTransformer;
import com.gamedash.daemon.common.api.server.request.Request;
import com.gamedash.daemon.common.api.server.request.input.parameter.RequestParameterException;
import com.gamedash.daemon.common.api.server.response.Response;
import com.gamedash.daemon.common.api.server.route.Route;
import com.gamedash.daemon.docker.Docker;
import com.gamedash.daemon.docker.DockerExposedPort;
import com.gamedash.daemon.docker.DockerHostConfig;
import com.gamedash.daemon.docker.DockerPortBinding;
import com.gamedash.daemon.docker.container.IDockerContainerBuilder;
import com.gamedash.daemon.docker.container.network.DockerContainerNetworkModeEnum;
import com.gamedash.daemon.docker.mount.DockerMount;
import com.gamedash.daemon.docker.mount.DockerMountType;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateContainer
extends Route<String> {
    private final Docker docker = Docker.getInstance();

    public CreateContainer(Request request, Response response) {
        super(request, response);
    }

    @Override
    public String execute() throws Exception {
        List<String> command;
        String user;
        String hostName;
        IDockerContainerBuilder builder = this.docker.getContainers().create(this.request.getInput().getParameters().get("imageName").getValue());
        String name = this.getName();
        if (name != null) {
            builder.withName(name);
        }
        if ((hostName = this.getHostName()) != null) {
            builder.withHostName(hostName);
        }
        if ((user = this.getUser()) != null) {
            builder.withUser(user);
        }
        if ((command = this.getCommand()) != null) {
            builder.withCommand(command);
        }
        builder.withEnvironmentVariables(this.getEnvironmentVariables());
        builder.withHostConfig(this.createHostConfig());
        return builder.build();
    }

    private String getName() throws Exception {
        if (this.request.getInput().getParameters().exists("name")) {
            return this.request.getInput().getParameters().get("name").getValue();
        }
        return null;
    }

    private String getHostName() throws Exception {
        if (this.request.getInput().getParameters().exists("hostName")) {
            return this.request.getInput().getParameters().get("hostName").getValue();
        }
        return null;
    }

    private String getUser() throws Exception {
        if (this.request.getInput().getParameters().exists("user")) {
            return this.request.getInput().getParameters().get("user").getValue();
        }
        return null;
    }

    private List<String> getCommand() {
        if (this.request.getInput().getParameters().exists("command")) {
            return this.request.getInput().getParameters().get("command").getList();
        }
        return null;
    }

    private DockerHostConfig createHostConfig() throws Exception {
        DockerContainerNetworkModeEnum networkMode;
        Boolean oomKillDisable;
        Long memorySwap;
        Long memoryReservation;
        Long memory;
        DockerHostConfig hostConfig = new DockerHostConfig();
        hostConfig.withPortBindings(this.getPortBindings());
        Integer cpuShares = this.getCpuShares();
        if (cpuShares != null) {
            hostConfig.withCpuShares(cpuShares);
        }
        if ((memory = this.getMemory()) != null) {
            hostConfig.withMemory(memory);
        }
        if ((memoryReservation = this.getMemoryReservation()) != null) {
            hostConfig.withMemoryReservation(memoryReservation);
        }
        if ((memorySwap = this.getMemorySwap()) != null) {
            hostConfig.withMemorySwap(memorySwap);
        }
        if ((oomKillDisable = this.getOOMKillDisable()) != null) {
            hostConfig.withOOMKillDisable(oomKillDisable);
        }
        if ((networkMode = this.getNetworkMode()) != null) {
            hostConfig.withNetworkMode(networkMode);
        }
        hostConfig.withMounts(this.getMounts());
        return hostConfig;
    }

    private Integer getCpuShares() {
        if (!this.request.getInput().getParameters().exists("cpuShares")) {
            return null;
        }
        return this.request.getInput().getParameters().get("cpuShares").getValue(new IntegerRequestParameterTransformer());
    }

    private Long getMemory() {
        if (!this.request.getInput().getParameters().exists("memory")) {
            return null;
        }
        return this.request.getInput().getParameters().get("memory").getValue(new LongRequestParameterTransformer());
    }

    private Boolean getOOMKillDisable() {
        if (!this.request.getInput().getParameters().exists("oomKillDisable")) {
            return null;
        }
        return this.request.getInput().getParameters().get("oomKillDisable").getValue(new BooleanRequestParameterTransformer());
    }

    private Long getMemoryReservation() {
        if (!this.request.getInput().getParameters().exists("memoryReservation")) {
            return null;
        }
        return this.request.getInput().getParameters().get("memoryReservation").getValue(new LongRequestParameterTransformer());
    }

    private Long getMemorySwap() {
        if (!this.request.getInput().getParameters().exists("memorySwap")) {
            return null;
        }
        return this.request.getInput().getParameters().get("memorySwap").getValue(new LongRequestParameterTransformer());
    }

    private DockerContainerNetworkModeEnum getNetworkMode() throws Exception {
        if (!this.request.getInput().getParameters().exists("networkMode")) {
            return null;
        }
        return DockerContainerNetworkModeEnum.valueOf(this.request.getInput().getParameters().get("networkMode").getValue());
    }

    private Map<String, String> getEnvironmentVariables() throws RequestParameterException {
        if (!this.request.getInput().getParameters().exists("environmentVariables")) {
            return new HashMap<String, String>();
        }
        EnvironmentVariableParameter[] environmentVariablesParameter = this.request.getInput().getParameters().get("environmentVariables").getJsonArray(EnvironmentVariableParameter[].class);
        HashMap<String, String> environmentVariables = new HashMap<String, String>();
        for (EnvironmentVariableParameter environmentVariableParameter : environmentVariablesParameter) {
            environmentVariables.put(environmentVariableParameter.key, environmentVariableParameter.value);
        }
        return environmentVariables;
    }

    private List<DockerMount> getMounts() throws RequestParameterException {
        if (!this.request.getInput().getParameters().exists("mounts")) {
            return new ArrayList<DockerMount>();
        }
        MountParameter[] mountsParameter = this.request.getInput().getParameters().get("mounts").getJsonArray(MountParameter[].class);
        ArrayList<DockerMount> mounts = new ArrayList<DockerMount>();
        for (MountParameter mountParameter : mountsParameter) {
            DockerMount mount = new DockerMount();
            mount.withSource(mountParameter.source);
            mount.withTarget(mountParameter.target);
            if (mountParameter.type != null) {
                mount.withType(DockerMountType.valueOf(mountParameter.type));
            }
            if (mountParameter.readOnly != null) {
                mount.withReadOnly(mountParameter.readOnly);
            }
            mounts.add(mount);
        }
        return mounts;
    }

    private List<DockerPortBinding> getPortBindings() throws RequestParameterException {
        if (!this.request.getInput().getParameters().exists("portBindings")) {
            return new ArrayList<DockerPortBinding>();
        }
        PortBindingParameter[] bindingsParameterArray = this.request.getInput().getParameters().get("portBindings").getJsonArray(PortBindingParameter[].class);
        ArrayList<DockerPortBinding> bindings = new ArrayList<DockerPortBinding>();
        for (PortBindingParameter parameter : bindingsParameterArray) {
            DockerExposedPort exposedPort = DockerExposedPort.create(parameter.exposedPort, parameter.exposedPortProtocol);
            bindings.add(new DockerPortBinding(parameter.port, exposedPort));
        }
        return bindings;
    }

    @Override
    public String[] getRequiredParameters() {
        return new String[]{"imageName"};
    }

    static class PortBindingParameter {
        @SerializedName(value="port")
        public Integer port;
        @SerializedName(value="exposedPort")
        public Integer exposedPort;
        @SerializedName(value="exposedPortProtocol")
        public String exposedPortProtocol;

        PortBindingParameter() {
        }
    }

    static class MountParameter {
        @SerializedName(value="source")
        public String source;
        @SerializedName(value="target")
        public String target;
        @SerializedName(value="type")
        public String type;
        @SerializedName(value="readOnly")
        public Boolean readOnly;

        MountParameter() {
        }
    }

    static class EnvironmentVariableParameter {
        @SerializedName(value="key")
        public String key;
        @SerializedName(value="value")
        private String value;

        EnvironmentVariableParameter() {
        }
    }
}

