/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.api.server.model.fileSystem.file;

import com.google.gson.annotations.SerializedName;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;

public class FileModel {
    @SerializedName(value="path")
    private String path;
    @SerializedName(value="realPath")
    private String realPath;
    @SerializedName(value="isDirectory")
    private Boolean isDirectory;
    @SerializedName(value="isSymlink")
    private boolean isSymlink;
    @SerializedName(value="size")
    private long size;
    @SerializedName(value="timestamp")
    private TimestampResult timestamp;

    public FileModel(File directory, File file) throws Exception {
        BasicFileAttributes attributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        this.path = directory.toPath().relativize(file.toPath()).toString();
        this.realPath = file.toPath().toRealPath(new LinkOption[0]).toString();
        this.isSymlink = Files.isSymbolicLink(file.toPath());
        this.isDirectory = file.isDirectory();
        if (file.isFile()) {
            this.size = file.length();
            this.timestamp = new TimestampResult(attributes.creationTime().toMillis() / 1000L, attributes.lastModifiedTime().toMillis() / 1000L);
        }
    }

    private static class TimestampResult {
        @SerializedName(value="created")
        private long created;
        @SerializedName(value="lastModified")
        private long lastModified;

        TimestampResult(long created, long lastModified) {
            this.created = created;
            this.lastModified = lastModified;
        }
    }
}

