/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon;

import com.gamedash.daemon.Args;
import com.gamedash.daemon.common.api.client.response.logger.QueryResponseLogger;
import com.gamedash.daemon.common.args.ArgsParser;
import com.gamedash.daemon.common.authentication.Authentication;
import com.gamedash.daemon.common.authentication.token.AuthenticationToken;
import com.gamedash.daemon.common.development.DevelopmentMode;
import com.gamedash.daemon.common.fileSystem.FileSystem;
import com.gamedash.daemon.common.installer.InstallerStateEnum;
import com.gamedash.daemon.common.time.Time;
import com.gamedash.daemon.flag.Flags;
import com.gamedash.daemon.initialization.implementation.ApiClientInitializer;
import com.gamedash.daemon.initialization.implementation.CGroupsInitializer;
import com.gamedash.daemon.initialization.implementation.ChildProcessesInitializer;
import com.gamedash.daemon.initialization.implementation.ConfigInitializer;
import com.gamedash.daemon.initialization.implementation.DependenciesInitializer;
import com.gamedash.daemon.initialization.implementation.DockerContainersInitializer;
import com.gamedash.daemon.initialization.implementation.FileSystemInitializer;
import com.gamedash.daemon.initialization.implementation.InfrastructureNodeStatusInitializer;
import com.gamedash.daemon.initialization.implementation.KeyStoreInitializer;
import com.gamedash.daemon.initialization.implementation.LicenseInitializer;
import com.gamedash.daemon.initialization.implementation.NetworkInitializer;
import com.gamedash.daemon.initialization.implementation.WindowsPlatformInitializer;
import com.gamedash.daemon.initialization.implementation.services.ServicesInitializer;
import com.gamedash.daemon.installer.Installer;
import com.gamedash.daemon.license.LicenseManager;
import com.gamedash.daemon.license.validation.LicenseValidationManager;
import com.gamedash.daemon.permission.Permissions;
import com.gamedash.daemon.platform.windows.bridge.WindowsBridge;
import com.gamedash.daemon.shutdown.ShutdownManager;
import java.io.File;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application {
    public static Args args = new Args();
    public static Time initTime = Time.now();
    public static final Logger logger = LoggerFactory.getLogger(Application.class);

    public void run(String[] args) {
        new ArgsParser(Application.args).parse(args);
        if (Application.args.logApiClient.booleanValue()) {
            this.initializeApiClientListener();
        }
        ShutdownManager.registerHook();
        if (Application.args.dev.booleanValue()) {
            logger.info("Enabling development mode");
            DevelopmentMode.setIsEnabled(true);
        }
        this.listenForDevelopmentMode();
        try {
            new ConfigInitializer().initialize();
            new FileSystemInitializer().initialize();
            new ChildProcessesInitializer().initialize();
            new CGroupsInitializer().initialize();
            new DockerContainersInitializer().initialize();
            if (SystemUtils.IS_OS_WINDOWS && !WindowsBridge.isInstalled()) {
                new WindowsPlatformInitializer().initialize();
            }
            if (!Application.isRunningWithRequiredPermissions()) {
                throw new RuntimeException("Running with elevated permissions is required");
            }
            new DependenciesInitializer().initialize();
            new NetworkInitializer().initialize();
            if (!Installer.isInstalled() || Flags.hasFlag("setup.install")) {
                this.handleSetupInstall();
            }
            if (Flags.hasFlag("setup.uninstall")) {
                this.handleSetupUninstall();
            }
            if (Application.args.installOnly.booleanValue()) {
                logger.info("Exiting due to running in \"install only\" mode");
                System.exit(0);
            }
            new ApiClientInitializer().initialize();
            new KeyStoreInitializer().initialize();
            this.initializeLicense();
            this.initializeServices();
            new InfrastructureNodeStatusInitializer().initialize();
            LicenseValidationManager.onValidityChange(result -> {
                if (!result.isValid()) {
                    logger.error("License has become invalid: " + result.getMessage());
                    System.exit(1);
                }
            });
            logger.info("Initialisation complete");
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace(e));
            System.exit(1);
        }
    }

    public void shutdown() throws Exception {
        ShutdownManager.run();
    }

    private void listenForDevelopmentMode() {
        DevelopmentMode.onStatusChange(status -> {
            ConsoleAppender consoleAppender = (ConsoleAppender)LogManager.getRootLogger().getAppender("STDOUT");
            consoleAppender.setThreshold(status ? Level.INFO : Level.DEBUG);
        });
    }

    private void initializeLicense() throws Exception {
        LicenseManager.ensureCurrentLicenseIsValid();
        new LicenseInitializer().initialize();
    }

    private void initializeApiClientListener() {
        if (!QueryResponseLogger.isListening()) {
            QueryResponseLogger.listen();
        }
    }

    private void initializeServices() {
        try {
            ServicesInitializer servicesInitializer = new ServicesInitializer();
            if (servicesInitializer.isAvailable()) {
                servicesInitializer.initialize();
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtils.getStackTrace(e));
            System.exit(1);
        }
    }

    private void handleSetupInstall() throws Exception {
        if (!Permissions.isRunningWithElevatedPermissions()) {
            throw new RuntimeException("Installation required elevated permissions");
        }
        Installer.install();
    }

    private void handleSetupUninstall() throws Exception {
        if (Installer.getState() != InstallerStateEnum.installed) {
            throw new Exception("Daemon is not currently installed");
        }
        Installer.uninstall();
        System.exit(0);
    }

    public static boolean isRunningWithRequiredPermissions() {
        if (SystemUtils.IS_OS_LINUX) {
            return System.getProperty("user.name").equals("root");
        }
        return true;
    }

    public static void setRootDirectory(File directory) {
        FileSystem.setRootDirectory(directory);
    }

    public static void setAuthenticationToken(String token) throws Exception {
        logger.info("Received new authentication token " + token);
        Authentication.setCurrentToken(new AuthenticationToken(token));
    }
}

