/*
 * Decompiled with CFR 0.152.
 */
package com.corundumstudio.socketio;

import com.corundumstudio.socketio.Configuration;
import com.corundumstudio.socketio.DisconnectableHub;
import com.corundumstudio.socketio.ack.AckManager;
import com.corundumstudio.socketio.handler.AuthorizeHandler;
import com.corundumstudio.socketio.handler.ClientHead;
import com.corundumstudio.socketio.handler.ClientsBox;
import com.corundumstudio.socketio.handler.EncoderHandler;
import com.corundumstudio.socketio.handler.InPacketHandler;
import com.corundumstudio.socketio.handler.PacketListener;
import com.corundumstudio.socketio.handler.WrongUrlHandler;
import com.corundumstudio.socketio.namespace.NamespacesHub;
import com.corundumstudio.socketio.protocol.JsonSupport;
import com.corundumstudio.socketio.protocol.PacketDecoder;
import com.corundumstudio.socketio.protocol.PacketEncoder;
import com.corundumstudio.socketio.scheduler.CancelableScheduler;
import com.corundumstudio.socketio.scheduler.HashedWheelTimeoutScheduler;
import com.corundumstudio.socketio.store.StoreFactory;
import com.corundumstudio.socketio.store.pubsub.DisconnectMessage;
import com.corundumstudio.socketio.store.pubsub.PubSubType;
import com.corundumstudio.socketio.transport.PollingTransport;
import com.corundumstudio.socketio.transport.WebSocketTransport;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import io.netty.handler.ssl.SslHandler;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketIOChannelInitializer
extends ChannelInitializer<Channel>
implements DisconnectableHub {
    public static final String SOCKETIO_ENCODER = "socketioEncoder";
    public static final String WEB_SOCKET_TRANSPORT_COMPRESSION = "webSocketTransportCompression";
    public static final String WEB_SOCKET_TRANSPORT = "webSocketTransport";
    public static final String WEB_SOCKET_AGGREGATOR = "webSocketAggregator";
    public static final String XHR_POLLING_TRANSPORT = "xhrPollingTransport";
    public static final String AUTHORIZE_HANDLER = "authorizeHandler";
    public static final String PACKET_HANDLER = "packetHandler";
    public static final String HTTP_ENCODER = "httpEncoder";
    public static final String HTTP_COMPRESSION = "httpCompression";
    public static final String HTTP_AGGREGATOR = "httpAggregator";
    public static final String HTTP_REQUEST_DECODER = "httpDecoder";
    public static final String SSL_HANDLER = "ssl";
    public static final String RESOURCE_HANDLER = "resourceHandler";
    public static final String WRONG_URL_HANDLER = "wrongUrlBlocker";
    private static final Logger log = LoggerFactory.getLogger(SocketIOChannelInitializer.class);
    private AckManager ackManager;
    private ClientsBox clientsBox = new ClientsBox();
    private AuthorizeHandler authorizeHandler;
    private PollingTransport xhrPollingTransport;
    private WebSocketTransport webSocketTransport;
    private WebSocketServerCompressionHandler webSocketTransportCompression = new WebSocketServerCompressionHandler();
    private EncoderHandler encoderHandler;
    private WrongUrlHandler wrongUrlHandler;
    private CancelableScheduler scheduler = new HashedWheelTimeoutScheduler();
    private InPacketHandler packetHandler;
    private SSLContext sslContext;
    private Configuration configuration;

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        this.scheduler.update(ctx);
    }

    public void start(Configuration configuration, NamespacesHub namespacesHub) {
        boolean isSsl;
        this.configuration = configuration;
        this.ackManager = new AckManager(this.scheduler);
        JsonSupport jsonSupport = configuration.getJsonSupport();
        PacketEncoder encoder = new PacketEncoder(configuration, jsonSupport);
        PacketDecoder decoder = new PacketDecoder(jsonSupport, this.ackManager);
        String connectPath = configuration.getContext() + "/";
        boolean bl = isSsl = configuration.getKeyStore() != null;
        if (isSsl) {
            try {
                this.sslContext = this.createSSLContext(configuration);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        StoreFactory factory = configuration.getStoreFactory();
        this.authorizeHandler = new AuthorizeHandler(connectPath, this.scheduler, configuration, namespacesHub, factory, this, this.ackManager, this.clientsBox);
        factory.init(namespacesHub, this.authorizeHandler, jsonSupport);
        this.xhrPollingTransport = new PollingTransport(decoder, this.authorizeHandler, this.clientsBox);
        this.webSocketTransport = new WebSocketTransport(isSsl, this.authorizeHandler, configuration, this.scheduler, this.clientsBox);
        PacketListener packetListener = new PacketListener(this.ackManager, namespacesHub, this.xhrPollingTransport, this.scheduler);
        this.packetHandler = new InPacketHandler(packetListener, decoder, namespacesHub, configuration.getExceptionListener());
        try {
            this.encoderHandler = new EncoderHandler(configuration, encoder);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.wrongUrlHandler = new WrongUrlHandler();
    }

    @Override
    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        this.addSslHandler(pipeline);
        this.addSocketioHandlers(pipeline);
    }

    protected void addSslHandler(ChannelPipeline pipeline) {
        if (this.sslContext != null) {
            SSLEngine engine = this.sslContext.createSSLEngine();
            engine.setUseClientMode(false);
            pipeline.addLast(SSL_HANDLER, (ChannelHandler)new SslHandler(engine));
        }
    }

    protected void addSocketioHandlers(ChannelPipeline pipeline) {
        pipeline.addLast(HTTP_REQUEST_DECODER, (ChannelHandler)new HttpRequestDecoder());
        pipeline.addLast(HTTP_AGGREGATOR, (ChannelHandler)new HttpObjectAggregator(this.configuration.getMaxHttpContentLength()){

            @Override
            protected Object newContinueResponse(HttpMessage start, int maxContentLength, ChannelPipeline pipeline) {
                return null;
            }
        });
        pipeline.addLast(HTTP_ENCODER, (ChannelHandler)new HttpResponseEncoder());
        if (this.configuration.isHttpCompression()) {
            pipeline.addLast(HTTP_COMPRESSION, (ChannelHandler)new HttpContentCompressor());
        }
        pipeline.addLast(PACKET_HANDLER, (ChannelHandler)this.packetHandler);
        pipeline.addLast(AUTHORIZE_HANDLER, (ChannelHandler)this.authorizeHandler);
        pipeline.addLast(XHR_POLLING_TRANSPORT, (ChannelHandler)this.xhrPollingTransport);
        if (this.configuration.isWebsocketCompression()) {
            pipeline.addLast(WEB_SOCKET_TRANSPORT_COMPRESSION, (ChannelHandler)new WebSocketServerCompressionHandler());
        }
        pipeline.addLast(WEB_SOCKET_TRANSPORT, (ChannelHandler)this.webSocketTransport);
        pipeline.addLast(SOCKETIO_ENCODER, (ChannelHandler)this.encoderHandler);
        pipeline.addLast(WRONG_URL_HANDLER, (ChannelHandler)this.wrongUrlHandler);
    }

    private SSLContext createSSLContext(Configuration configuration) throws Exception {
        TrustManager[] managers = null;
        if (configuration.getTrustStore() != null) {
            KeyStore ts = KeyStore.getInstance(configuration.getTrustStoreFormat());
            ts.load(configuration.getTrustStore(), configuration.getTrustStorePassword().toCharArray());
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ts);
            managers = tmf.getTrustManagers();
        }
        KeyStore ks = KeyStore.getInstance(configuration.getKeyStoreFormat());
        ks.load(configuration.getKeyStore(), configuration.getKeyStorePassword().toCharArray());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(configuration.getKeyManagerFactoryAlgorithm());
        kmf.init(ks, configuration.getKeyStorePassword().toCharArray());
        SSLContext serverContext = SSLContext.getInstance(configuration.getSSLProtocol());
        serverContext.init(kmf.getKeyManagers(), managers, null);
        return serverContext;
    }

    @Override
    public void onDisconnect(ClientHead client) {
        this.ackManager.onDisconnect(client);
        this.authorizeHandler.onDisconnect(client);
        this.configuration.getStoreFactory().onDisconnect(client);
        this.configuration.getStoreFactory().pubSubStore().publish(PubSubType.DISCONNECT, new DisconnectMessage(client.getSessionId()));
        log.debug("Client with sessionId: {} disconnected", (Object)client.getSessionId());
    }

    public void stop() {
        StoreFactory factory = this.configuration.getStoreFactory();
        factory.shutdown();
        this.scheduler.shutdown();
    }
}

