/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.usermanager.impl;

import org.apache.ftpserver.ftplet.Authority;
import org.apache.ftpserver.ftplet.AuthorizationRequest;
import org.apache.ftpserver.usermanager.impl.ConcurrentLoginRequest;

public class ConcurrentLoginPermission
implements Authority {
    private final int maxConcurrentLogins;
    private final int maxConcurrentLoginsPerIP;

    public ConcurrentLoginPermission(int maxConcurrentLogins, int maxConcurrentLoginsPerIP) {
        this.maxConcurrentLogins = maxConcurrentLogins;
        this.maxConcurrentLoginsPerIP = maxConcurrentLoginsPerIP;
    }

    @Override
    public AuthorizationRequest authorize(AuthorizationRequest request) {
        if (request instanceof ConcurrentLoginRequest) {
            ConcurrentLoginRequest concurrentLoginRequest = (ConcurrentLoginRequest)request;
            if (this.maxConcurrentLogins != 0 && this.maxConcurrentLogins < concurrentLoginRequest.getConcurrentLogins()) {
                return null;
            }
            if (this.maxConcurrentLoginsPerIP != 0 && this.maxConcurrentLoginsPerIP < concurrentLoginRequest.getConcurrentLoginsFromThisIP()) {
                return null;
            }
            concurrentLoginRequest.setMaxConcurrentLogins(this.maxConcurrentLogins);
            concurrentLoginRequest.setMaxConcurrentLoginsPerIP(this.maxConcurrentLoginsPerIP);
            return concurrentLoginRequest;
        }
        return null;
    }

    @Override
    public boolean canAuthorize(AuthorizationRequest request) {
        return request instanceof ConcurrentLoginRequest;
    }
}

