/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.command.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketException;
import org.apache.ftpserver.command.AbstractCommand;
import org.apache.ftpserver.command.impl.listing.DirectoryLister;
import org.apache.ftpserver.command.impl.listing.LISTFileFormater;
import org.apache.ftpserver.command.impl.listing.ListArgument;
import org.apache.ftpserver.command.impl.listing.ListArgumentParser;
import org.apache.ftpserver.ftplet.DataConnection;
import org.apache.ftpserver.ftplet.DefaultFtpReply;
import org.apache.ftpserver.ftplet.FtpException;
import org.apache.ftpserver.ftplet.FtpFile;
import org.apache.ftpserver.ftplet.FtpRequest;
import org.apache.ftpserver.impl.FtpIoSession;
import org.apache.ftpserver.impl.FtpServerContext;
import org.apache.ftpserver.impl.IODataConnectionFactory;
import org.apache.ftpserver.impl.LocalizedDataTransferFtpReply;
import org.apache.ftpserver.impl.LocalizedFtpReply;
import org.apache.ftpserver.impl.ServerDataConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LIST
extends AbstractCommand {
    private final Logger LOG = LoggerFactory.getLogger(LIST.class);
    private static final LISTFileFormater LIST_FILE_FORMATER = new LISTFileFormater();
    private final DirectoryLister directoryLister = new DirectoryLister();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(FtpIoSession session, FtpServerContext context, FtpRequest request) throws IOException, FtpException {
        try {
            DataConnection dataConnection;
            InetAddress address;
            session.resetState();
            ListArgument parsedArg = ListArgumentParser.parse(request.getArgument());
            FtpFile file = session.getFileSystemView().getFile(parsedArg.getFile());
            if (!file.doesExist()) {
                this.LOG.debug("Listing on a non-existing file");
                session.write(LocalizedDataTransferFtpReply.translate(session, request, context, 450, "LIST", null, file));
                return;
            }
            ServerDataConnectionFactory connFactory = session.getDataConnection();
            if (connFactory instanceof IODataConnectionFactory && (address = ((IODataConnectionFactory)connFactory).getInetAddress()) == null) {
                session.write(new DefaultFtpReply(503, "PORT or PASV must be issued first"));
                return;
            }
            session.write(LocalizedFtpReply.translate(session, request, context, 150, "LIST", null));
            try {
                dataConnection = session.getDataConnection().openConnection();
            }
            catch (Exception e) {
                this.LOG.debug("Exception getting the output data stream", e);
                session.write(LocalizedDataTransferFtpReply.translate(session, request, context, 425, "LIST", null, file));
                session.getDataConnection().closeDataConnection();
                return;
            }
            boolean failure = false;
            String dirList = this.directoryLister.listFiles(parsedArg, session.getFileSystemView(), LIST_FILE_FORMATER);
            try {
                dataConnection.transferToClient(session.getFtpletSession(), dirList);
            }
            catch (SocketException ex) {
                this.LOG.debug("Socket exception during list transfer", ex);
                failure = true;
                session.write(LocalizedDataTransferFtpReply.translate(session, request, context, 426, "LIST", null, file));
            }
            catch (IOException ex) {
                this.LOG.debug("IOException during list transfer", ex);
                failure = true;
                session.write(LocalizedDataTransferFtpReply.translate(session, request, context, 551, "LIST", null, file));
            }
            catch (IllegalArgumentException e) {
                this.LOG.debug("Illegal list syntax: " + request.getArgument(), e);
                session.write(LocalizedDataTransferFtpReply.translate(session, request, context, 501, "LIST", null, file));
            }
            if (!failure) {
                session.write(LocalizedDataTransferFtpReply.translate(session, request, context, 226, "LIST", null, file, dirList.length()));
            }
        }
        finally {
            session.getDataConnection().closeDataConnection();
        }
    }
}

