/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.transport;

import com.github.dockerjava.transport.DockerHttpClient;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="DockerHttpClient.Request", generator="Immutables")
@SuppressFBWarnings
@Immutable
final class ImmutableRequest
extends DockerHttpClient.Request {
    private final String method;
    private final String path;
    @Nullable
    private final InputStream body;
    @Nullable
    private final InputStream hijackedInput;
    private final Map<String, String> headers;

    private ImmutableRequest(String method, String path, @Nullable InputStream body, @Nullable InputStream hijackedInput, Map<String, String> headers) {
        this.method = method;
        this.path = path;
        this.body = body;
        this.hijackedInput = hijackedInput;
        this.headers = headers;
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    @Nullable
    public InputStream body() {
        return this.body;
    }

    @Override
    @Nullable
    public InputStream hijackedInput() {
        return this.hijackedInput;
    }

    @Override
    public Map<String, String> headers() {
        return this.headers;
    }

    public final ImmutableRequest withMethod(String value) {
        String newValue = Objects.requireNonNull(value, "method");
        if (this.method.equals(newValue)) {
            return this;
        }
        return new ImmutableRequest(newValue, this.path, this.body, this.hijackedInput, this.headers);
    }

    public final ImmutableRequest withPath(String value) {
        String newValue = Objects.requireNonNull(value, "path");
        if (this.path.equals(newValue)) {
            return this;
        }
        return new ImmutableRequest(this.method, newValue, this.body, this.hijackedInput, this.headers);
    }

    public final ImmutableRequest withBody(@Nullable InputStream value) {
        if (this.body == value) {
            return this;
        }
        return new ImmutableRequest(this.method, this.path, value, this.hijackedInput, this.headers);
    }

    public final ImmutableRequest withHijackedInput(@Nullable InputStream value) {
        if (this.hijackedInput == value) {
            return this;
        }
        return new ImmutableRequest(this.method, this.path, this.body, value, this.headers);
    }

    public final ImmutableRequest withHeaders(Map<String, ? extends String> entries) {
        if (this.headers == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableRequest.createUnmodifiableMap(true, false, entries);
        return new ImmutableRequest(this.method, this.path, this.body, this.hijackedInput, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRequest && this.equalTo((ImmutableRequest)another);
    }

    private boolean equalTo(ImmutableRequest another) {
        return this.method.equals(another.method) && this.path.equals(another.path) && Objects.equals(this.body, another.body) && Objects.equals(this.hijackedInput, another.hijackedInput) && this.headers.equals(another.headers);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.method.hashCode();
        h2 += (h2 << 5) + this.path.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.body);
        h2 += (h2 << 5) + Objects.hashCode(this.hijackedInput);
        h2 += (h2 << 5) + this.headers.hashCode();
        return h2;
    }

    public String toString() {
        return "Request{method=" + this.method + ", path=" + this.path + ", body=" + this.body + ", hijackedInput=" + this.hijackedInput + ", headers=" + this.headers + "}";
    }

    public static DockerHttpClient.Request copyOf(DockerHttpClient.Request instance) {
        if (instance instanceof ImmutableRequest) {
            return (ImmutableRequest)instance;
        }
        return new DockerHttpClient.Request.Builder().from(instance).build();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="DockerHttpClient.Request", generator="Immutables")
    @NotThreadSafe
    public static class Builder {
        private static final long INIT_BIT_METHOD = 1L;
        private static final long INIT_BIT_PATH = 2L;
        private long initBits = 3L;
        @Nullable
        private String method;
        @Nullable
        private String path;
        @Nullable
        private InputStream body;
        @Nullable
        private InputStream hijackedInput;
        private Map<String, String> headers = new LinkedHashMap<String, String>();

        public Builder() {
            if (!(this instanceof DockerHttpClient.Request.Builder)) {
                throw new UnsupportedOperationException("Use: new DockerHttpClient.Request.Builder()");
            }
        }

        public final DockerHttpClient.Request.Builder from(DockerHttpClient.Request instance) {
            InputStream hijackedInputValue;
            Objects.requireNonNull(instance, "instance");
            this.method(instance.method());
            this.path(instance.path());
            InputStream bodyValue = instance.body();
            if (bodyValue != null) {
                this.body(bodyValue);
            }
            if ((hijackedInputValue = instance.hijackedInput()) != null) {
                this.hijackedInput(hijackedInputValue);
            }
            this.putAllHeaders(instance.headers());
            return (DockerHttpClient.Request.Builder)this;
        }

        public final DockerHttpClient.Request.Builder method(String method) {
            this.method = Objects.requireNonNull(method, "method");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (DockerHttpClient.Request.Builder)this;
        }

        public final DockerHttpClient.Request.Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (DockerHttpClient.Request.Builder)this;
        }

        public final DockerHttpClient.Request.Builder body(@Nullable InputStream body) {
            this.body = body;
            return (DockerHttpClient.Request.Builder)this;
        }

        public final DockerHttpClient.Request.Builder hijackedInput(@Nullable InputStream hijackedInput) {
            this.hijackedInput = hijackedInput;
            return (DockerHttpClient.Request.Builder)this;
        }

        public final DockerHttpClient.Request.Builder putHeader(String key, String value) {
            this.headers.put(Objects.requireNonNull(key, "headers key"), Objects.requireNonNull(value, "headers value"));
            return (DockerHttpClient.Request.Builder)this;
        }

        public final DockerHttpClient.Request.Builder putHeader(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.headers.put(Objects.requireNonNull(k, "headers key"), Objects.requireNonNull(v, "headers value"));
            return (DockerHttpClient.Request.Builder)this;
        }

        public final DockerHttpClient.Request.Builder headers(Map<String, ? extends String> entries) {
            this.headers.clear();
            return this.putAllHeaders(entries);
        }

        public final DockerHttpClient.Request.Builder putAllHeaders(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.headers.put(Objects.requireNonNull(k, "headers key"), Objects.requireNonNull(v, "headers value"));
            }
            return (DockerHttpClient.Request.Builder)this;
        }

        public DockerHttpClient.Request build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRequest(this.method, this.path, this.body, this.hijackedInput, ImmutableRequest.createUnmodifiableMap(false, false, this.headers));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("method");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("path");
            }
            return "Cannot build Request, some of required attributes are not set " + attributes;
        }
    }
}

