/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.platform.windows;

import com.gamedash.daemon.platform.windows.process.WindowsPlatformProcess;
import com.gamedash.daemon.platform.windows.process.WindowsPlatformProcesses;
import com.gamedash.daemon.platform.windows.process.WindowsPlatformResourceProcessUsage;
import com.gamedash.daemon.platform.windows.process.priority.WindowsPlatformProcessPriorityHelper;
import com.gamedash.daemon.process.IProcess;
import com.gamedash.daemon.process.ProcessResourceUsageResult;
import com.gamedash.daemon.process.platform.AbstractProcess;
import com.gamedash.daemon.process.platform.windows.WindowsResourceLimitEnforcementManager;
import com.gamedash.daemon.process.resource.limit.CPUResourceLimit;
import com.gamedash.daemon.process.resource.limit.IResourceLimitEnforcementManager;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class WindowsProcess
extends AbstractProcess {
    private WindowsPlatformProcess api;

    public WindowsProcess(int id) {
        super(id);
    }

    @Override
    public String getName() throws Exception {
        return this.getApi().getName();
    }

    @Override
    public String[] getCommandLine() throws Exception {
        String[] cmdLine = new String[]{this.getFileName()};
        return ArrayUtils.addAll(cmdLine, this.getArguments());
    }

    public String getFileName() throws Exception {
        return this.getApi().getFileName();
    }

    public String[] getArguments() throws Exception {
        return this.getApi().getArguments();
    }

    @Override
    public File getWorkingDirectory() throws Exception {
        return this.getApi().getWorkingDirectory();
    }

    @Override
    public List<IProcess> getChildren() throws Exception {
        ArrayList<IProcess> processes = new ArrayList<IProcess>();
        for (WindowsPlatformProcess process : this.getApi().getChildren()) {
            processes.add(new WindowsProcess(process.getId()));
        }
        return processes;
    }

    @Override
    public void kill() throws Exception {
        this.getApi().kill();
    }

    @Override
    public void kill(String signal) throws Exception {
        this.getApi().kill();
    }

    @Override
    public void stop() throws Exception {
        this.getApi().kill();
    }

    @Override
    public ProcessResourceUsageResult getResourceUsage() throws Exception {
        WindowsPlatformResourceProcessUsage apiResourceUsage = this.getApi().getResourceUsage();
        return new ProcessResourceUsageResult(apiResourceUsage.getCpuPercentage(), apiResourceUsage.getRamMb());
    }

    @Override
    public void enforceResourceLimits() throws Exception {
        this.enforceCPUResourceLimit();
    }

    public void enforceCPUResourceLimit() throws Exception {
        CPUResourceLimit cpu = this.getCPUResourceLimit();
        if (cpu.getProcessorAffinity() != null) {
            this.ensureAffinityProcessorsIsInRange(cpu.getProcessorAffinity());
            this.getApi().setProcessorAffinity(cpu.getProcessorAffinity());
        }
        if (cpu.getPriority() != null) {
            this.getApi().setPriority(WindowsPlatformProcessPriorityHelper.from(cpu.getPriority()));
        }
    }

    public WindowsPlatformProcess getApi() {
        if (this.api == null) {
            this.api = WindowsPlatformProcesses.get(this.getId());
        }
        return this.api;
    }

    @Override
    protected IResourceLimitEnforcementManager createResourceLimitEnforcementManager() {
        return new WindowsResourceLimitEnforcementManager(this);
    }
}

