/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.terminal.pty;

import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.terminal.AbstractTerminal;
import com.gamedash.daemon.process.childProcess.terminal.ITerminal;
import com.gamedash.daemon.process.childProcess.terminal.io.IIo;
import com.gamedash.daemon.process.childProcess.terminal.pty.PtyIo;
import com.pty4j.PtyProcess;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pty
extends AbstractTerminal
implements ITerminal {
    public static final Logger logger = LoggerFactory.getLogger(Pty.class);
    private final ChildProcess childProcess;
    private final IIo io;
    private PtyProcess api;

    public Pty(ChildProcess childProcess) throws IOException {
        this.childProcess = childProcess;
        this.io = new PtyIo(this.childProcess);
    }

    @Override
    public void spawn(String[] args) throws Exception {
        Map<String, String> environmentVariables = this.childProcess.getEnvironmentVariables();
        this.api = PtyProcess.exec(args, environmentVariables, this.childProcess.hasWorkingDirectory() != false ? this.childProcess.getWorkingDirectory().toString() : null);
        this.getIo().listen();
        this.api.onExit().thenRunAsync(this::handleExit);
    }

    @Override
    public void stop() throws Exception {
        this.getIo().destroy();
        List<ProcessHandle> descendants = this.getDescendants();
        if (this.api.supportsNormalTermination()) {
            this.api.destroy();
            if (descendants.size() > 0) {
                descendants.forEach(ProcessHandle::destroy);
            }
            this.waitForExit(5);
            this.api.destroyForcibly();
            if (descendants.size() > 0) {
                descendants.forEach(ProcessHandle::destroyForcibly);
            }
        } else {
            this.api.destroyForcibly();
        }
        this.waitForExit();
    }

    @Override
    public List<ProcessHandle> getDescendants() {
        return this.api.descendants().collect(Collectors.toList());
    }

    @Override
    public int getExitCode() {
        return this.api.exitValue();
    }

    @Override
    public boolean isRunning() {
        return this.api.isRunning();
    }

    @Override
    public int getId() {
        return this.api.getPid();
    }

    @Override
    public IIo getIo() {
        return this.io;
    }

    @Override
    public <T> T getApi(Class<T> type) {
        return type.cast(this.api);
    }
}

