/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.terminal.io.output.queue;

import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.io.OutputItem;
import com.gamedash.daemon.process.childProcess.terminal.ITerminal;
import com.gamedash.daemon.process.childProcess.terminal.io.output.queue.OutputQueueManager;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputQueueWorker {
    protected static final Logger logger = LoggerFactory.getLogger(OutputQueueWorker.class);
    private final ChildProcess childProcess;
    private final OutputQueueManager queueManager;
    private final ReentrantLock takeLock = new ReentrantLock();
    private final Condition runningSync = this.takeLock.newCondition();
    private Thread thread;
    private Boolean running = false;
    private Boolean requestingStop = false;

    public OutputQueueWorker(ChildProcess childProcess, OutputQueueManager queueManager) {
        this.childProcess = childProcess;
        this.queueManager = queueManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        this.setIsRunning(true);
        while (this.isRunning().booleanValue()) {
            try {
                if (this.isRequestingStop().booleanValue() && this.queueManager.queueIsEmpty()) break;
                OutputItem outputItem = this.queueManager.pollQueuedOutputItem(500L, TimeUnit.MILLISECONDS);
                if (outputItem == null) continue;
                this.process(outputItem);
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) continue;
                logger.error(ExceptionUtils.getStackTrace(e));
            }
        }
        this.setIsRunning(false);
        Condition condition = this.runningSync;
        synchronized (condition) {
            this.runningSync.notifyAll();
        }
    }

    public Thread startAsync() {
        Thread thread = new Thread(() -> {
            try {
                this.start();
            }
            catch (Exception e) {
                logger.error(ExceptionUtils.getStackTrace(e));
            }
        });
        thread.start();
        this.setThread(thread);
        return thread;
    }

    public void stop() throws InterruptedException {
        this.stop(this.childProcess.getIo().shouldAwait());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(Boolean await) throws InterruptedException {
        if (!this.isRunning().booleanValue()) {
            return;
        }
        if (await.booleanValue()) {
            Condition condition = this.runningSync;
            synchronized (condition) {
                this.setIsRequestingStop(true);
                while (this.isRunning().booleanValue()) {
                    this.runningSync.wait();
                }
            }
        } else {
            this.setIsRequestingStop(true);
        }
        Thread thread = this.getThread();
        if (thread != null) {
            thread.interrupt();
        }
    }

    private void process(OutputItem item) throws Exception {
        ITerminal terminal = this.childProcess.getTerminal().getInstance();
        terminal.getIo().addOutputItem(item);
        for (CompletableFuture<Void> future : terminal.getIo().invokeOnOutputListener(item)) {
            future.get();
        }
    }

    public Boolean isRunning() {
        return this.running;
    }

    private void setIsRunning(Boolean running) {
        this.running = running;
    }

    private Boolean isRequestingStop() {
        return this.requestingStop;
    }

    private void setIsRequestingStop(Boolean requestingStop) {
        this.requestingStop = requestingStop;
    }

    private Thread getThread() {
        return this.thread;
    }

    private void setThread(Thread thread) {
        this.thread = thread;
    }
}

