/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.terminal.io.output.queue;

import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.io.OutputItem;
import com.gamedash.daemon.process.childProcess.terminal.io.output.queue.OutputQueueWorker;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutputQueueManager {
    private static final Logger logger = LoggerFactory.getLogger(OutputQueueManager.class);
    private final ChildProcess childProcess;
    private final List<OutputQueueWorker> workers = new ArrayList<OutputQueueWorker>();
    private final LinkedBlockingQueue<OutputItem> queuedOutputItems = new LinkedBlockingQueue();

    public OutputQueueManager(ChildProcess childProcess) {
        this.childProcess = childProcess;
    }

    public void queueOutputItem(OutputItem item) {
        this.queuedOutputItems.add(item);
    }

    public OutputItem takeQueuedOutputItem() throws InterruptedException {
        return this.queuedOutputItems.take();
    }

    public OutputItem pollQueuedOutputItem() {
        return this.queuedOutputItems.poll();
    }

    public OutputItem pollQueuedOutputItem(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.queuedOutputItems.poll(timeout, timeUnit);
    }

    public boolean queueIsEmpty() {
        return this.queuedOutputItems.isEmpty();
    }

    public List<OutputQueueWorker> getWorkers() {
        return this.workers;
    }

    public void stopWorkers() throws InterruptedException {
        for (OutputQueueWorker worker : this.getWorkers()) {
            if (!worker.isRunning().booleanValue()) continue;
            worker.stop();
        }
    }

    public void stopWorkersGracefully() throws InterruptedException {
        this.stopWorkers();
    }

    public List<OutputQueueWorker> getRunningWorkers() {
        return this.getWorkers().stream().filter(OutputQueueWorker::isRunning).collect(Collectors.toList());
    }

    public List<OutputQueueWorker> getStoppedWorkers() {
        return this.getWorkers().stream().filter(worker -> worker.isRunning() == false).collect(Collectors.toList());
    }

    public OutputQueueWorker createWorker() {
        return new OutputQueueWorker(this.childProcess, this);
    }

    public List<OutputQueueWorker> createPool(int size) {
        List<OutputQueueWorker> stoppedWorkers = this.getStoppedWorkers();
        ArrayList<OutputQueueWorker> workers = new ArrayList<OutputQueueWorker>(stoppedWorkers.subList(0, Math.min(stoppedWorkers.size(), size)));
        if (size > workers.size()) {
            int requiredWorkers = size - workers.size();
            for (int i = 0; i < requiredWorkers; ++i) {
                workers.add(this.createWorker());
            }
        }
        logger.info("Creating pool with " + (workers.size() - stoppedWorkers.size()) + " new workers and " + stoppedWorkers.size() + " recycled workers");
        workers.forEach(worker -> {
            if (!worker.isRunning().booleanValue()) {
                worker.startAsync();
            }
        });
        this.addWorkers(workers);
        return workers;
    }

    public void addWorker(OutputQueueWorker worker) {
        this.workers.add(worker);
    }

    public void addWorkers(List<OutputQueueWorker> workers) {
        this.workers.addAll(workers);
    }

    public void removeWorker(OutputQueueWorker worker) {
        this.workers.remove(worker);
    }
}

