/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.terminal.io;

import com.gamedash.daemon.process.childProcess.io.OutputItem;
import com.gamedash.daemon.process.childProcess.terminal.io.AbstractIo;
import com.gamedash.daemon.process.childProcess.terminal.io.IIo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.lang3.exception.ExceptionUtils;

public interface IQueuedInputStreamListener
extends IIo {
    default public void listenToInputStream(InputStream inputStream, boolean isErrorStream) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String value;
            while ((value = bufferedReader.readLine()) != null) {
                try {
                    OutputItem outputItem = new OutputItem(value, isErrorStream);
                    this.getOutputQueueManager().queueOutputItem(outputItem);
                }
                catch (Exception e) {
                    AbstractIo.logger.error(ExceptionUtils.getStackTrace(e));
                }
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    default public Thread createThreadedInputStreamListener(InputStream inputStream, boolean isError) {
        return new Thread(() -> {
            try {
                this.listenToInputStream(inputStream, isError);
            }
            catch (Exception e) {
                AbstractIo.logger.error(ExceptionUtils.getStackTrace(e));
            }
        });
    }
}

