/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.process.childProcess.io;

import com.gamedash.daemon.common.config.Config;
import com.gamedash.daemon.common.config.ConfigException;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.io.IOnCloseCallback;
import com.gamedash.daemon.process.childProcess.io.IOnOutputCallback;
import com.gamedash.daemon.process.childProcess.io.OutputItem;
import com.gamedash.daemon.process.childProcess.io.listener.IIOListener;
import com.gamedash.daemon.process.childProcess.terminal.ITerminal;
import com.gamedash.daemon.process.childProcess.terminal.io.IIo;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class Io {
    private final ChildProcess childProcess;
    private final ITerminal terminal;
    private final IIo terminalIo;
    private final List<IIOListener> listeners = new CopyOnWriteArrayList<IIOListener>();
    private boolean await = true;

    public Io(ChildProcess childProcess) throws Exception {
        this.childProcess = childProcess;
        this.terminal = this.childProcess.getTerminal().getInstance();
        this.terminalIo = this.terminal.getIo();
    }

    public void write(String value) throws Exception {
        this.terminalIo.write(value);
    }

    public void destroy() throws Exception {
        this.terminalIo.destroy();
    }

    public List<OutputItem> getOutputItems() {
        return this.terminalIo.getOutputItems();
    }

    public List<OutputItem> getOutputItems(int tail) {
        return this.terminalIo.getOutputItems(tail);
    }

    public void onOutput(IOnOutputCallback callback) {
        this.terminalIo.onOutput(callback);
    }

    public void onClose(IOnCloseCallback callback) {
        this.terminalIo.onClose(callback);
    }

    public void waitFor() throws Exception {
        this.terminalIo.waitFor();
    }

    public void listen() throws Exception {
        this.terminalIo.listen();
    }

    public List<IIOListener> getListeners() {
        return this.listeners;
    }

    public void addListener(IIOListener listener) {
        this.listeners.add(listener);
    }

    public boolean shouldAwait() {
        return this.await;
    }

    public void setShouldAwait(boolean await) {
        this.await = await;
    }

    public static int getHistorySize() throws IOException, ConfigException {
        if (!Config.getFile("daemon.properties").valueExists("childProcess.terminal.io.output.history.size")) {
            return 250;
        }
        return Config.getFile("daemon.properties").getValue("childProcess.terminal.io.output.history.size", Integer.class);
    }
}

