/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.platform.linux.system.user;

import com.gamedash.daemon.platform.linux.system.user.LinuxSystemUser;
import com.gamedash.daemon.platform.linux.system.user.LinuxSystemUserException;
import com.gamedash.daemon.process.childProcess.ChildProcess;
import com.gamedash.daemon.process.childProcess.ChildProcesses;
import com.gamedash.daemon.system.user.ISystemUsers;

public class LinuxSystemUsers
implements ISystemUsers {
    @Override
    public boolean exists(String name) throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.spawn("id", new String[]{"\"" + name + "\""});
        childProcess.waitForExit();
        if (childProcess.getExitCode() != 0 && childProcess.getExitCode() != 1) {
            throw new LinuxSystemUserException("Could not check if user exists");
        }
        return childProcess.getIo().getOutputItems().get(0) != null && childProcess.getIo().getOutputItems().get(0).getValue().charAt(0) == 'u';
    }

    @Override
    public LinuxSystemUser create(String name, String password) throws Exception {
        ChildProcess childProcess = ChildProcesses.create();
        childProcess.spawn("useradd", new String[]{"-p", "$(openssl passwd -1 \"" + password + "\")", "\"" + name + "\""});
        childProcess.waitForExit();
        if (childProcess.getExitCode() != 0) {
            throw new LinuxSystemUserException("Could not create");
        }
        return this.get(name);
    }

    @Override
    public LinuxSystemUser get(String name) {
        return new LinuxSystemUser(name);
    }
}

