/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.network.port;

import com.gamedash.daemon.common.singleton.SingletonList;
import com.gamedash.daemon.network.port.Port;
import com.gamedash.daemon.platform.linux.network.port.LinuxNetworkPorts;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SystemUtils;

public class Ports {
    private static final SingletonList<Port> ports = new SingletonList<Port>(){

        @Override
        public boolean compare(Port a, Port b) {
            return a.getNumber() == b.getNumber();
        }
    };

    public static List<Port> getOpen() throws Exception {
        if (SystemUtils.IS_OS_LINUX) {
            return LinuxNetworkPorts.getOpen().stream().map(linuxNetworkPort -> linuxNetworkPort).collect(Collectors.toList());
        }
        return new ArrayList<Port>();
    }

    public static Port get(int number) {
        Port port = ports.find(_port -> _port.getNumber() == number);
        if (port == null) {
            port = new Port(number);
            ports.add(port);
        }
        return port;
    }

    public static boolean isOpen(int number) throws Exception {
        for (Port port : Ports.getOpen()) {
            if (port.getNumber() != number) continue;
            return true;
        }
        return false;
    }
}

