/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.installer;

import com.gamedash.daemon.Application;
import com.gamedash.daemon.common.api.client.ApiClientConfig;
import com.gamedash.daemon.common.authentication.Authentication;
import com.gamedash.daemon.common.authentication.AuthenticationToken;
import com.gamedash.daemon.common.config.Config;
import com.gamedash.daemon.common.fileSystem.FileSystem;
import com.gamedash.daemon.common.installer.InstallerStateEnum;
import com.gamedash.daemon.common.security.keyStore.KeyStore;
import com.gamedash.daemon.fileSystem.file.registered.RequiredFileAlreadyExistsException;
import com.gamedash.daemon.fileSystem.file.registered.RequiredFiles;
import com.gamedash.daemon.installer.InstallerException;
import com.gamedash.daemon.installer.userInterface.UserInterface;
import com.gamedash.daemon.installer.userInterface.UserInterfaceQuestionsResult;
import java.io.File;
import java.io.IOException;

public class Installer
extends com.gamedash.daemon.common.installer.Installer {
    public static void install() throws Exception {
        if (!Config.fileExists("daemon.properties")) {
            Config.createFile("daemon.properties");
        }
        Installer.setState(InstallerStateEnum.inProgress);
        try {
            Installer.validateArguments();
            UserInterface ui = new UserInterface();
            UserInterfaceQuestionsResult result = ui.askQuestions();
            if (Application.args.installerApiIsSecure != null) {
                ApiClientConfig.setIsSecure(Application.args.installerApiIsSecure);
            }
            ApiClientConfig.setDomain(Application.args.installerApiDomain != null ? Application.args.installerApiDomain : result.apiClientDomain);
            AuthenticationToken authenticationToken = Application.args.installerAuthenticationToken != null ? Authentication.getToken(Application.args.installerAuthenticationToken) : result.authenticationToken;
            Authentication.setCurrentToken(authenticationToken);
            ApiClientConfig.setVersion("1");
            KeyStore.setFile(Application.args.installerKeyStoreFile != null ? new File(Application.args.installerKeyStoreFile) : result.security.keyStoreFile);
            KeyStore.setPassword(Application.args.installerKeyStorePassword != null ? Application.args.installerKeyStorePassword : result.security.keyStorePassword);
            KeyStore.setIsSelfSigned(Application.args.installerKeyStoreIsSelfSigned != null ? Application.args.installerKeyStoreIsSelfSigned : result.security.keyStoreIsSelfSigned);
            try {
                RequiredFiles.create("daemon", FileSystem.getRootDirectory(), true);
            }
            catch (RequiredFileAlreadyExistsException requiredFileAlreadyExistsException) {}
        }
        catch (Exception e) {
            Installer.setState(InstallerStateEnum.notInstalled);
            throw e;
        }
        Installer.setState(InstallerStateEnum.installed);
    }

    public static void uninstall() throws IOException {
        if (Config.fileExists("daemon.properties")) {
            Config.getFile("daemon.properties").delete();
        }
    }

    private static void validateArguments() throws Exception {
        if (Application.args.installerKeyStoreFile != null && Application.args.installerKeyStorePassword == null || Application.args.installerKeyStoreFile == null && Application.args.installerKeyStorePassword != null) {
            throw new InstallerException("Must supply both a keystore file and password");
        }
        if (Application.args.installerKeyStoreFile != null) {
            File keyStoreFile = new File(Application.args.installerKeyStoreFile);
            if (!keyStoreFile.exists()) {
                throw new InstallerException("Keystore file does not exist");
            }
            if (!KeyStore.validatePassword(keyStoreFile, Application.args.installerKeyStorePassword)) {
                throw new InstallerException("Invalid keystore password");
            }
        }
    }

    public static boolean isInstalled() throws IOException {
        return Installer.getState() == InstallerStateEnum.installed;
    }
}

