/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.initialization.implementation.services;

import com.gamedash.daemon.api.server.ApiServer;
import com.gamedash.daemon.api.server.ApiServers;
import com.gamedash.daemon.common.api.server.ApiServerKeyStore;
import com.gamedash.daemon.common.config.Config;
import com.gamedash.daemon.common.initialization.implementation.InitializerImplementation;
import com.gamedash.daemon.common.security.keyStore.KeyStore;
import java.io.IOException;

public class HttpsApiServiceInitializer
extends InitializerImplementation {
    @Override
    public void initialize() throws Exception {
        ApiServer httpsInstance = ApiServers.createInstance();
        httpsInstance.setKeyStore(new ApiServerKeyStore(KeyStore.getFile(), KeyStore.getPassword()));
        httpsInstance.setPort(this.getPort());
        httpsInstance.start();
    }

    @Override
    public void destroy() throws Exception {
        for (ApiServer server : ApiServers.getInstances()) {
            if (!server.isRunning().booleanValue() || server.getPort().intValue() != this.getPort()) continue;
            server.stop();
        }
    }

    @Override
    public boolean isAvailable() throws Exception {
        return KeyStore.hasFile() != false && KeyStore.hasPassword();
    }

    private int getPort() throws IOException {
        return Config.getFile("daemon.properties").valueExists("api.server.https.port") ? Config.getFile("daemon.properties").getValue("api.server.https.port", Integer.class) : 2147;
    }
}

