/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker.implementation.generic.container;

import com.gamedash.daemon.docker.DockerExposedPort;
import com.gamedash.daemon.docker.DockerInternetProtocol;
import com.gamedash.daemon.docker.DockerPortBinding;
import com.gamedash.daemon.docker.DockerVolume;
import com.gamedash.daemon.docker.implementation.container.AbstractDockerContainerBuilder;
import com.gamedash.daemon.docker.implementation.generic.GenericDockerImplementation;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.CreateContainerResponse;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.Volume;
import java.util.ArrayList;
import java.util.List;

public class GenericDockerContainerBuilder
extends AbstractDockerContainerBuilder {
    public GenericDockerContainerBuilder(String imageName) {
        super(imageName);
    }

    @Override
    public String build() {
        CreateContainerCmd cmd = GenericDockerImplementation.getClient().createContainerCmd(this.getImageName());
        if (this.getWorkingDirectory() != null) {
            cmd.withWorkingDir(this.getWorkingDirectory());
        }
        if (this.getEnv() != null) {
            cmd.withEnv(this.getEnvAsList());
        }
        if (this.getHostName() != null) {
            cmd.withHostName(this.getHostName());
        }
        if (this.getName() != null) {
            cmd.withName(this.getName());
        }
        cmd.withHostConfig(this.createHostConfig());
        cmd.withVolumes(this.createVolumes());
        cmd.withTty(true);
        cmd.withAttachStderr(true);
        cmd.withAttachStdin(true);
        cmd.withAttachStdout(true);
        cmd.withStdinOpen(true);
        if (this.getCommand() != null) {
            cmd.withCmd(this.getCommand());
        }
        CreateContainerResponse response = cmd.exec();
        return response.getId();
    }

    private List<Volume> createVolumes() {
        ArrayList<Volume> volumes = new ArrayList<Volume>();
        for (DockerVolume dockerVolume : this.getVolumes()) {
            volumes.add(new Volume(dockerVolume.getOrigin() + ":" + dockerVolume.getTarget()));
        }
        return volumes;
    }

    private HostConfig createHostConfig() {
        HostConfig hostConfig = new HostConfig();
        if (this.getHostConfig().getCpuShares() != null) {
            hostConfig.withCpuShares(this.getHostConfig().getCpuShares());
        }
        if (this.getHostConfig().getMemory() != null) {
            hostConfig.withMemory(this.getHostConfig().getMemory());
        }
        if (this.getHostConfig().getMemoryReservation() != null) {
            hostConfig.withMemoryReservation(this.getHostConfig().getMemoryReservation());
        }
        if (this.getHostConfig().getMemorySwap() != null) {
            hostConfig.withMemorySwap(this.getHostConfig().getMemorySwap());
        }
        if (this.getHostConfig().getCpuQuota() != null) {
            hostConfig.withCpuQuota(this.getHostConfig().getCpuQuota());
        }
        if (this.getHostConfig().getCpuPeriod() != null) {
            hostConfig.withCpuPeriod(this.getHostConfig().getCpuPeriod());
        }
        if (this.getHostConfig().getCpuShares() != null) {
            hostConfig.withCpuShares(this.getHostConfig().getCpuShares());
        }
        if (this.getHostConfig().getBlkioWeight() != null) {
            hostConfig.withBlkioWeight(this.getHostConfig().getBlkioWeight());
        }
        hostConfig.withPortBindings(this.createPortBindings());
        hostConfig.withDns("8.8.8.8", "8.8.4.4");
        hostConfig.withOomKillDisable(false);
        return hostConfig;
    }

    private ExposedPort createExposedPort(DockerExposedPort dockerExposedPort) {
        if (dockerExposedPort.getInternetProtocol() == DockerInternetProtocol.TCP) {
            return ExposedPort.tcp(dockerExposedPort.getPort());
        }
        if (dockerExposedPort.getInternetProtocol() == DockerInternetProtocol.UDP) {
            return ExposedPort.udp(dockerExposedPort.getPort());
        }
        if (dockerExposedPort.getInternetProtocol() == DockerInternetProtocol.SCTP) {
            return ExposedPort.sctp(dockerExposedPort.getPort());
        }
        return null;
    }

    private List<PortBinding> createPortBindings() {
        ArrayList<PortBinding> portBindings = new ArrayList<PortBinding>();
        for (DockerPortBinding dockerPortBinding : this.getHostConfig().getPortBindings()) {
            portBindings.add(new PortBinding(Ports.Binding.bindPort(dockerPortBinding.getPort()), this.createExposedPort(dockerPortBinding.getExposedPort())));
        }
        return portBindings;
    }
}

