/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker.implementation.generic.container;

import com.gamedash.daemon.docker.implementation.IDockerImplementation;
import com.gamedash.daemon.docker.implementation.container.IDockerImplementationContainer;
import com.gamedash.daemon.docker.implementation.container.IDockerImplementationContainerHostConfig;
import com.gamedash.daemon.docker.implementation.container.IDockerImplementationContainerMount;
import com.gamedash.daemon.docker.implementation.container.IDockerImplementationContainerNetwork;
import com.gamedash.daemon.docker.implementation.container.IDockerImplementationContainerPort;
import com.gamedash.daemon.docker.implementation.generic.GenericDockerImplementation;
import com.gamedash.daemon.docker.implementation.generic.container.GenericDockerContainerHostConfig;
import com.gamedash.daemon.docker.implementation.generic.container.GenericDockerContainerMount;
import com.gamedash.daemon.docker.implementation.generic.container.GenericDockerContainerNetwork;
import com.gamedash.daemon.docker.implementation.generic.container.GenericDockerContainerPort;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.api.model.ContainerMount;
import com.github.dockerjava.api.model.ContainerNetwork;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class GenericDockerContainer
implements IDockerImplementationContainer {
    private IDockerImplementation implementation;
    private Container containerModel;

    public GenericDockerContainer(IDockerImplementation implementation, Container containerModel) {
        this.implementation = implementation;
        this.containerModel = containerModel;
    }

    @Override
    public String getId() {
        return this.containerModel.getId();
    }

    @Override
    public String[] getNames() {
        return this.containerModel.getNames();
    }

    @Override
    public String getImage() {
        return this.containerModel.getImage();
    }

    @Override
    public String getImageId() {
        return this.containerModel.getImageId();
    }

    @Override
    public boolean isRunning() throws Exception {
        for (IDockerImplementationContainer container : this.implementation.getContainers().getRunning()) {
            if (!container.getId().equals(this.getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<IDockerImplementationContainerPort> getPorts() {
        return Arrays.stream(this.containerModel.getPorts()).map(GenericDockerContainerPort::new).collect(Collectors.toList());
    }

    @Override
    public void start() {
        GenericDockerImplementation.getClient().startContainerCmd(this.getId()).exec();
    }

    @Override
    public void stop() {
        GenericDockerImplementation.getClient().stopContainerCmd(this.getId()).exec();
    }

    @Override
    public void kill() throws Exception {
        this.kill("SIGKILL");
    }

    @Override
    public void kill(String signal) throws Exception {
        GenericDockerImplementation.getClient().killContainerCmd(this.getId()).withSignal(signal).exec();
    }

    @Override
    public void remove() throws Exception {
        GenericDockerImplementation.getClient().removeContainerCmd(this.getId()).exec();
    }

    @Override
    public Map<String, String> getLabels() {
        return this.containerModel.getLabels();
    }

    @Override
    public Long getRootSize() {
        return this.containerModel.getSizeRootFs();
    }

    @Override
    public List<IDockerImplementationContainerNetwork> getNetworks() {
        ArrayList<IDockerImplementationContainerNetwork> networks = new ArrayList<IDockerImplementationContainerNetwork>();
        if (this.containerModel.getNetworkSettings() != null) {
            this.containerModel.getNetworkSettings().getNetworks().forEach((name, networkModel) -> networks.add(new GenericDockerContainerNetwork(this, (String)name, (ContainerNetwork)networkModel)));
        }
        return networks;
    }

    @Override
    public IDockerImplementationContainerHostConfig getHostConfig() {
        return new GenericDockerContainerHostConfig(this, this.containerModel.getHostConfig());
    }

    @Override
    public List<IDockerImplementationContainerMount> getMounts() {
        return this.containerModel.getMounts().stream().map(model -> new GenericDockerContainerMount(this, (ContainerMount)model)).collect(Collectors.toList());
    }
}

