/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker.implementation.generic;

import com.gamedash.daemon.docker.implementation.IDockerImplementation;
import com.gamedash.daemon.docker.implementation.generic.container.GenericDockerContainers;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;

public class GenericDockerImplementation
implements IDockerImplementation {
    private static DockerClient client;
    private final GenericDockerContainers containers = new GenericDockerContainers(this);

    @Override
    public boolean isRunning() {
        GenericDockerImplementation.getClient().pingCmd().exec();
        return false;
    }

    @Override
    public GenericDockerContainers getContainers() {
        return this.containers;
    }

    public static synchronized DockerClient getClient() {
        if (client == null) {
            client = GenericDockerImplementation.createClient();
        }
        return client;
    }

    public static DockerClient createClient() {
        DockerClientConfig config = GenericDockerImplementation.createConfig();
        return DockerClientImpl.getInstance(config, GenericDockerImplementation.createHttpClient(config));
    }

    public static DockerHttpClient createHttpClient(DockerClientConfig config) {
        return new ApacheDockerHttpClient.Builder().dockerHost(config.getDockerHost()).sslConfig(config.getSSLConfig()).build();
    }

    public static DockerClientConfig createConfig() {
        return DefaultDockerClientConfig.createDefaultConfigBuilder().build();
    }
}

