/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker.implementation.generic;

import com.gamedash.daemon.docker.implementation.IDockerImplementationHostConfig;
import com.gamedash.daemon.docker.implementation.generic.container.GenericDockerContainer;
import com.github.dockerjava.api.model.HostConfig;

public class GenericDockerHostConfig
implements IDockerImplementationHostConfig {
    private GenericDockerContainer container;
    private HostConfig model;

    public GenericDockerHostConfig(GenericDockerContainer container, HostConfig model) {
        this.container = container;
        this.model = model;
    }

    public Integer getBlkioWeight() {
        return this.model.getBlkioWeight();
    }

    public Long getMemorySwappiness() {
        return this.model.getMemorySwappiness();
    }

    public Long getNanoCPUs() {
        return this.model.getNanoCPUs();
    }

    public String getContainerIDFile() {
        return this.model.getContainerIDFile();
    }

    public Long getCpuPeriod() {
        return this.model.getCpuPeriod();
    }

    public Long getCpuRealtimePeriod() {
        return this.model.getCpuRealtimePeriod();
    }

    public Long getCpuRealtimeRuntime() {
        return this.model.getCpuRealtimeRuntime();
    }

    public Integer getCpuShares() {
        return this.model.getCpuShares();
    }

    public Long getCpuQuota() {
        return this.model.getCpuQuota();
    }

    public Long getDiskQuota() {
        return this.model.getDiskQuota();
    }

    public String getCGroup() {
        return this.model.getCgroup();
    }

    public Long getMemory() {
        return this.model.getMemory();
    }

    public Long getMemorySwap() {
        return this.model.getMemorySwap();
    }

    public Long getMemoryReservation() {
        return this.model.getMemoryReservation();
    }

    public Long getKernelMemory() {
        return this.model.getKernelMemory();
    }

    public String getRestartPolicyName() {
        return this.model.getRestartPolicy().getName();
    }

    public Integer getRestartPolicyMaximumRetryCount() {
        return this.model.getRestartPolicy().getMaximumRetryCount();
    }

    public Long getCpuCount() {
        return this.model.getCpuCount();
    }

    public Long getCpuPercent() {
        return this.model.getCpuPercent();
    }

    public Long getIoMaximumIOps() {
        return this.model.getIoMaximumIOps();
    }

    public Long getIoMaximumBandwidth() {
        return this.model.getIoMaximumBandwidth();
    }

    @Override
    public String getNetworkMode() {
        return this.model.getNetworkMode();
    }
}

