/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker.container;

import com.gamedash.daemon.docker.container.DockerContainerHostConfig;
import com.gamedash.daemon.docker.container.DockerContainerMount;
import com.gamedash.daemon.docker.container.DockerContainerNetwork;
import com.gamedash.daemon.docker.container.DockerContainerPort;
import com.gamedash.daemon.docker.implementation.container.IDockerImplementationContainer;
import com.gamedash.daemon.docker.implementation.container.IDockerImplementationContainerMount;
import com.gamedash.daemon.docker.implementation.container.IDockerImplementationContainerNetwork;
import com.gamedash.daemon.docker.implementation.container.IDockerImplementationContainerPort;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DockerContainer {
    private IDockerImplementationContainer implementation;

    public DockerContainer(IDockerImplementationContainer implementation) {
        this.implementation = implementation;
    }

    public String getId() {
        return this.implementation.getId();
    }

    public String getImage() {
        return this.implementation.getImage();
    }

    public String getImageId() {
        return this.implementation.getImageId();
    }

    public Map<String, String> getLabels() {
        return this.implementation.getLabels();
    }

    public Long getRootSize() {
        return this.implementation.getRootSize();
    }

    public List<DockerContainerPort> getPorts() {
        return this.implementation.getPorts().stream().map(implementation -> new DockerContainerPort(this, (IDockerImplementationContainerPort)implementation)).collect(Collectors.toList());
    }

    public List<DockerContainerMount> getMounts() {
        return this.implementation.getMounts().stream().map(implementation -> new DockerContainerMount(this, (IDockerImplementationContainerMount)implementation)).collect(Collectors.toList());
    }

    public DockerContainerHostConfig getHostConfig() {
        return new DockerContainerHostConfig(this, this.implementation.getHostConfig());
    }

    public List<DockerContainerNetwork> getNetworks() {
        return this.implementation.getNetworks().stream().map(implementation -> new DockerContainerNetwork(this, (IDockerImplementationContainerNetwork)implementation)).collect(Collectors.toList());
    }

    public void start() throws Exception {
        this.implementation.start();
    }

    public void stop() throws Exception {
        this.implementation.stop();
    }

    public void kill() throws Exception {
        this.implementation.kill();
    }

    public void remove() throws Exception {
        this.implementation.remove();
    }

    public boolean isRunning() throws Exception {
        return this.implementation.isRunning();
    }
}

