/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.docker;

import com.gamedash.daemon.docker.container.DockerContainers;
import com.gamedash.daemon.docker.implementation.IDockerImplementation;
import com.gamedash.daemon.docker.implementation.generic.GenericDockerImplementation;
import java.util.HashMap;
import java.util.Map;

public class Docker {
    private static final Map<String, Docker> instances = new HashMap<String, Docker>();
    private final IDockerImplementation implementation;
    private final DockerContainers containers;

    public Docker(IDockerImplementation implementation) {
        this.implementation = implementation;
        this.containers = new DockerContainers(this);
    }

    public IDockerImplementation getImplementation() {
        return this.implementation;
    }

    public DockerContainers getContainers() {
        return this.containers;
    }

    public static synchronized Docker getInstance() {
        return Docker.getInstance(new GenericDockerImplementation());
    }

    public static synchronized Docker getInstance(IDockerImplementation implementation) {
        String key = implementation.getClass().getCanonicalName();
        if (!instances.containsKey(key)) {
            instances.put(key, new Docker(implementation));
        }
        return instances.get(key);
    }

    public static Docker createInstance(IDockerImplementation implementation) {
        return new Docker(implementation);
    }
}

