/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.relay.server.listener;

import com.gamedash.daemon.common.relay.server.RelayServer;
import com.gamedash.daemon.common.relay.server.client.RelayClient;
import com.gamedash.daemon.common.relay.server.listener.IListener;
import com.gamedash.daemon.common.relay.server.message.payload.ErrorPayload;
import java.util.ArrayList;
import java.util.List;

public class RemoveChannelsListener
implements IListener {
    private final RelayServer server;

    public RemoveChannelsListener(RelayServer server) {
        this.server = server;
    }

    @Override
    public void listen() {
        this.server.getApi().addEventListener("removeChannels", Input.class, (socketIoClient, input, ackSender) -> {
            RelayClient client = this.server.getClients().get(socketIoClient.getSessionId());
            input.getChannels().forEach(channelName -> {
                if (!this.server.getChannels().exists((String)channelName)) {
                    ackSender.sendAckData(new ErrorPayload("Currently not subscribed to channel " + channelName));
                    return;
                }
                client.getChannels().remove((String)channelName);
                ackSender.sendAckData(new Object[0]);
            });
        });
    }

    public static class Input {
        private final List<String> channels = new ArrayList<String>();

        public List<String> getChannels() {
            return this.channels;
        }
    }
}

