/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.relay.server.channel;

import com.gamedash.daemon.common.relay.server.RelayServer;
import com.gamedash.daemon.common.relay.server.channel.RelayChannelClientsDirectory;
import com.gamedash.daemon.common.relay.server.client.RelayClient;
import com.gamedash.daemon.common.relay.server.message.RelayMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelayChannel {
    private static final Logger logger = LoggerFactory.getLogger(RelayChannel.class);
    private final RelayServer server;
    private final String name;
    private final RelayChannelClientsDirectory clientsDirectory;

    public RelayChannel(RelayServer server, String name) {
        this.server = server;
        this.name = name;
        this.clientsDirectory = new RelayChannelClientsDirectory(server, this);
    }

    public String getName() {
        return this.name;
    }

    public RelayChannelClientsDirectory getClients() {
        return this.clientsDirectory;
    }

    public boolean compareName(String name) {
        return this.getName().equalsIgnoreCase(name);
    }

    public void delete() {
        this.server.getChannels().delete(this.getName());
    }

    public void broadcast(RelayMessage<?> message) {
        logger.debug("Broadcasting message \"" + message.getMessage() + "\" with type " + message.getType() + " to channel " + this.getName());
        message.setChannel(this.getName());
        for (RelayClient client : this.getClients().getAll()) {
            client.sendMessage(message);
        }
    }

    public boolean equals(RelayChannel channel) {
        return this.compareName(channel.getName());
    }
}

