/*
 * Decompiled with CFR 0.152.
 */
package com.gamedash.daemon.common.relay.server;

import com.corundumstudio.socketio.Configuration;
import com.corundumstudio.socketio.SocketConfig;
import com.corundumstudio.socketio.SocketIOServer;
import com.gamedash.daemon.common.config.ConfigException;
import com.gamedash.daemon.common.network.Network;
import com.gamedash.daemon.common.relay.server.channel.RelayChannels;
import com.gamedash.daemon.common.relay.server.client.RelayClient;
import com.gamedash.daemon.common.relay.server.client.RelayClients;
import com.gamedash.daemon.common.relay.server.listener.registry.ListenersRegistry;
import com.gamedash.daemon.common.security.keyStore.KeyStore;
import java.io.FileInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelayServer {
    private static final Logger logger = LoggerFactory.getLogger(RelayServer.class);
    private final RelayChannels channels = new RelayChannels(this);
    private final RelayClients clients = new RelayClients(this);
    private final ListenersRegistry listeners = new ListenersRegistry(this);
    private SocketIOServer api;
    private Integer port;
    private boolean secure = true;

    public void start() throws Exception {
        int port = this.getPort();
        logger.info("Starting relay server on port " + port);
        Configuration configuration = new Configuration();
        configuration.setHostname(Network.getIp().getHostAddress());
        configuration.setPort(port);
        if (this.isSecure() && KeyStore.hasFile().booleanValue() && KeyStore.getFile().exists() && KeyStore.hasPassword()) {
            configuration.setKeyStore(new FileInputStream(KeyStore.getFile()));
            configuration.setKeyStorePassword(KeyStore.getPassword());
        }
        SocketConfig socketConfiguration = configuration.getSocketConfig();
        socketConfiguration.setReuseAddress(true);
        this.setApi(new SocketIOServer(configuration));
        this.api.addConnectListener(socketIoClient -> {
            try {
                if (!this.getClients().exists(socketIoClient.getSessionId())) {
                    this.getClients().create(socketIoClient);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.api.addDisconnectListener(socketIoClient -> {
            if (this.getClients().exists(socketIoClient.getSessionId())) {
                RelayClient client = this.getClients().get(socketIoClient.getSessionId());
                client.delete();
            }
        });
        this.getListeners().listen();
        this.api.start();
    }

    public void stop() throws Exception {
        if (!this.hasStarted()) {
            throw new Exception("Server is currently not running");
        }
        logger.info("Stopping relay server");
        this.getClients().getAll().forEach(RelayClient::delete);
        this.getApi().stop();
    }

    public boolean hasStarted() {
        return this.getApi() != null;
    }

    public int getPort() throws ConfigException {
        if (this.port != null) {
            return this.port;
        }
        return 2148;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setIsSecure(boolean secure) {
        this.secure = secure;
    }

    public RelayChannels getChannels() {
        return this.channels;
    }

    public RelayClients getClients() {
        return this.clients;
    }

    public ListenersRegistry getListeners() {
        return this.listeners;
    }

    public SocketIOServer getApi() {
        return this.api;
    }

    private void setApi(SocketIOServer api) {
        this.api = api;
    }
}

